/*
 * Shift_JIS encoding utilities
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: ShiftJis.java 578 2009-08-03 17:31:06Z olyutorskii $
 */

package jp.sourceforge.jindolf.parser;

import java.nio.charset.Charset;

/**
 * シフトJIS符号化ユーティリティ。
 * JIS X0208:1997 準拠。（Windows-31Jではない！）
 * @see <a href="http://www.iana.org/assignments/character-sets">
 * CHARACTER SETS</a>
 */
public class ShiftJis{
    
    public static final Charset CHARSET = Charset.forName("Shift_JIS");

    /**
     * 任意のバイト値がシフトJISの1バイト目でありうるか否か判定する。
     * @param ch バイト値
     * @return シフトJISの1バイト目でありうるならtrue
     */
    public static boolean isShiftJIS1stByte(byte ch){
        if(   (byte)0x81 <= ch && ch <= (byte)0x9f
           || (byte)0xe0 <= ch && ch <= (byte)0xfc){
            return true;
        }
        return false;
    }

    /**
     * 任意のバイト値がシフトJISの2バイト目でありうるか否か判定する。
     * @param ch バイト値
     * @return シフトJISの2バイト目でありうるならtrue
     */
    public static boolean isShiftJIS2ndByte(byte ch){
        if(   (byte)0x40 <= ch && ch <= (byte)0x7e
           || (byte)0x80 <= ch && ch <= (byte)0xfc){
            return true;
        }
        return false;
    }

    /**
     * 隠しコンストラクタ
     */
    private ShiftJis(){
        super();
        return;
    }

}
