/*
 * stream decoder for Shift_JIS
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: SjisDecoder.java 578 2009-08-03 17:31:06Z olyutorskii $
 */

package jp.sourceforge.jindolf.parser;

import java.io.IOException;
import java.nio.charset.CoderResult;

/**
 * ShiftJISのデコードに特化したStreamDecoderの派生クラス。
 * @see <a href="http://www.iana.org/assignments/character-sets">
 * CHARACTER SETS</a>
 */
public class SjisDecoder extends StreamDecoder{

    /**
     * コンストラクタ
     */
    public SjisDecoder(){
        super(ShiftJis.CHARSET.newDecoder());
        return;
    }

    /**
     * コンストラクタ
     * @param inbuf_sz 入力バッファサイズ
     * @param outbuf_sz 出力バッファサイズ
     */
    public SjisDecoder(int inbuf_sz, int outbuf_sz){
        super(ShiftJis.CHARSET.newDecoder(), inbuf_sz, outbuf_sz);
        return;
    }

    /**
     * {@inheritDoc}
     * JISX0208の文字集合を満たさない文字の2バイト目もデコードエラーに含める。
     * @param result {@inheritDoc}
     * @return {@inheritDoc}
     * @throws java.io.IOException {@inheritDoc}
     */
    @Override
    protected int chopErrorSequence(CoderResult result)
            throws IOException{
        int errorLength = result.length();

        if(result.isUnmappable() && errorLength == 1){
            int currPos;
            int nextPos;

            currPos = this.byteBuffer.position();
            nextPos = currPos + 1;
            if(nextPos >= this.byteBuffer.limit()){
                readByteBuffer();
                currPos = this.byteBuffer.position();
                nextPos = currPos + 1;
            }
            
            if(nextPos < this.byteBuffer.limit()){
                byte curr = this.byteBuffer.get(currPos);
                byte next = this.byteBuffer.get(nextPos);
                if(   ShiftJis.isShiftJIS1stByte(curr)
                   && ShiftJis.isShiftJIS2ndByte(next)){
                    result = CoderResult.unmappableForLength(2);
                }
            }
        }

        return super.chopErrorSequence(result);
    }

}
