/*
 * Copyright(c) 2009 olyutorskii
 * $Id: EntityConverterTest.java 638 2009-08-07 18:01:32Z olyutorskii $
 */

package jp.sourceforge.jindolf.parser;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 */
public class EntityConverterTest {

    public EntityConverterTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception{
    }

    @AfterClass
    public static void tearDownClass() throws Exception{
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of convert method, of class EntityConverter.
     */
    @Test
    public void testConvert(){
        System.out.println("convert");
        EntityConverter converter = new EntityConverter();

        DecodedContent from;
        DecodedContent result;
        
        from = new DecodedContent();
        from.append("a&gt;b&lt;c&quot;d&amp;e");
        result = converter.convert(from, 0, from.length());
        assertEquals("a>b<c\"d&e", result.toString());

        from = new DecodedContent();
        from.append("&gt;&lt;&quot;&amp;");
        result = converter.convert(from, 0, from.length());
        assertEquals("><\"&", result.toString());

        from = new DecodedContent();
        from.append("12345");
        result = converter.convert(from, 1, 3);
        assertEquals("23", result.toString());

        from = new DecodedContent();
        from.append("12&gt;45");
        result = converter.convert(from, 1, 7);
        assertEquals("2>4", result.toString());

        from = new DecodedContent();
        from.append("");
        result = converter.convert(from, 0, 0);
        assertEquals("", result.toString());

        return;
    }

}
