/*
 * Copyright(c) 2009 olyutorskii
 * $Id: EntityConverterTest.java 774 2009-08-29 03:13:14Z olyutorskii $
 */

package jp.sourceforge.jindolf.parser;

import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 */
public class EntityConverterTest {

    public EntityConverterTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception{
    }

    @AfterClass
    public static void tearDownClass() throws Exception{
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of convert method, of class EntityConverter.
     */
    @Test
    public void testConvert(){
        System.out.println("convert");

        EntityConverter converter = new EntityConverter();

        DecodedContent from;
        DecodedContent result;

        from = new DecodedContent();
        from.append("a&gt;b&lt;c&quot;d&amp;e");
        result = converter.convert(from, 0, from.length());
        assertEquals("a>b<c\"d&e", result.toString());

        from = new DecodedContent();
        from.append("&gt;&lt;&quot;&amp;");
        result = converter.convert(from, 0, from.length());
        assertEquals("><\"&", result.toString());

        from = new DecodedContent();
        from.append("12345");
        result = converter.convert(from, 1, 3);
        assertEquals("23", result.toString());

        from = new DecodedContent();
        from.append("12&gt;45");
        result = converter.convert(from, 1, 7);
        assertEquals("2>4", result.toString());

        from = new DecodedContent();
        from.append("12&gt;45");
        result = converter.convert(from, 3, 7);
        assertEquals("gt;4", result.toString());

        from = new DecodedContent();
        from.append("&amp;gt;");
        result = converter.convert(from, 0, from.length());
        assertEquals("&gt;", result.toString());

        from = new DecodedContent();
        from.append("a&gt;b");
        result = converter.convert(from);
        assertEquals("a>b", result.toString());

        from = new DecodedContent();
        from.append("a&gt;b");
        from.addDecodeError((byte)0x03);
        from.append("c");
        result = converter.convert(from);
        assertEquals("a>b?c", result.toString());
        assertTrue(result.hasDecodeError());
        List<DecodeErrorInfo> list = result.getDecodeErrorList();
        assertEquals(1, list.size());
        assertEquals((byte)0x03, list.get(0).getRawByte1st());

        from = new DecodedContent();
        from.append("");
        result = converter.convert(from, 0, 0);
        assertEquals("", result.toString());

        from = new DecodedContent();
        from.append("a\\b");
        result = converter.convert(from, 0, from.length());
        assertEquals("a¥b", result.toString());

        from = new DecodedContent();
        from.append("abcde");
        SeqRange range = new SeqRange(1,4);
        result = converter.convert(from, range);
        assertEquals("bcd", result.toString());

        return;
    }

}
