/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import jp.sourceforge.jindolf.Jindolf;

public final class GUIUtils {
    public static final AffineTransform AFFINETX_IDENTITY = new AffineTransform();
    public static final Font DEFAULT_FONT = Font.decode("Dialog");
    public static final FontRenderContext DEFAULT_FRC = new FontRenderContext(AFFINETX_IDENTITY, true, true);
    private static final String RES_LOGOICON = "resources/image/logo.png";
    private static final String RES_WINDOWICON = "resources/image/winicon.png";
    private static final String RES_WWWICON = "resources/image/www.png";
    private static final String RES_NOIMAGE = "resources/image/noimage.png";
    private static Image logoImage;
    private static Icon logoIcon;
    private static Image windowIconImage;
    private static Icon wwwIcon;
    private static ImageIcon noimageIcon;
    private static final RenderingHints HINTS_QUALITY;
    private static final RenderingHints HINTS_SPEEDY;
    private static final Runnable TASK_NOTHING;

    public static RenderingHints getQualityHints() {
        return HINTS_QUALITY;
    }

    public static Image loadImageFromResource(String resource) throws IOException {
        URL url = Jindolf.getResource(resource);
        BufferedImage result = ImageIO.read(url);
        return result;
    }

    public static Image getLogoImage() {
        Image image;
        if (logoImage != null) {
            return logoImage;
        }
        try {
            image = GUIUtils.loadImageFromResource(RES_LOGOICON);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30ed\u30b4\u30a4\u30e1\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            image = new BufferedImage(100, 100, 2);
        }
        logoImage = image;
        return logoImage;
    }

    public static Image getWindowIconImage() {
        Image image;
        if (windowIconImage != null) {
            return windowIconImage;
        }
        try {
            image = GUIUtils.loadImageFromResource(RES_WINDOWICON);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30a2\u30a4\u30b3\u30f3\u30a4\u30e1\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            image = GUIUtils.getLogoImage();
        }
        windowIconImage = image;
        return windowIconImage;
    }

    public static Icon getLogoIcon() {
        if (logoIcon != null) {
            return logoIcon;
        }
        ImageIcon icon = new ImageIcon(GUIUtils.getLogoImage());
        logoIcon = icon;
        return logoIcon;
    }

    public static Icon getWWWIcon() {
        if (wwwIcon != null) {
            return wwwIcon;
        }
        URL url = Jindolf.getResource(RES_WWWICON);
        wwwIcon = new ImageIcon(url);
        return wwwIcon;
    }

    public static ImageIcon getNoImageIcon() {
        if (noimageIcon != null) {
            return noimageIcon;
        }
        URL url = Jindolf.getResource(RES_NOIMAGE);
        noimageIcon = new ImageIcon(url);
        return noimageIcon;
    }

    public static void dispatchEmptyAWTEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(TASK_NOTHING);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static int getDirection(Rectangle rect, Point pt) {
        if (pt.y < rect.y) {
            return 1;
        }
        if (rect.y + rect.height <= pt.y) {
            return 5;
        }
        if (pt.x < rect.x) {
            return 3;
        }
        if (rect.x + rect.width <= pt.x) {
            return 7;
        }
        return 0;
    }

    public static void modifyWindowAttributes(Window window, boolean isResizable, boolean isDynamic, boolean isAutoLocation) {
        Toolkit kit = window.getToolkit();
        kit.setDynamicLayout(isDynamic);
        window.setLocationByPlatform(isAutoLocation);
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            frame.setIconImage(GUIUtils.getWindowIconImage());
            frame.setResizable(isResizable);
        } else if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            dialog.setResizable(isResizable);
        }
    }

    public static void forceMonoPitchFont(JComponent comp) {
        JTextComponent textComp;
        Font font = comp.getFont();
        int style = font.getStyle();
        int size = font.getSize();
        Font monofont = new Font("Monospaced", style, size);
        comp.setFont(monofont);
        if (comp instanceof JTextComponent && !(textComp = (JTextComponent)comp).isEditable()) {
            textComp.setCaretPosition(0);
        }
        comp.revalidate();
    }

    public static void addMargin(JComponent comp, int top, int left, int bottom, int right) {
        Border outer = comp.getBorder();
        Border inner = BorderFactory.createEmptyBorder(top, left, bottom, right);
        Border border = outer == null ? inner : BorderFactory.createCompoundBorder(outer, inner);
        comp.setBorder(border);
    }

    private GUIUtils() {
        assert (false);
        throw new Error();
    }

    static {
        TASK_NOTHING = new Runnable(){

            public void run() {
            }
        };
        HINTS_QUALITY = new RenderingHints(null);
        HINTS_SPEEDY = new RenderingHints(null);
        HINTS_QUALITY.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        HINTS_SPEEDY.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        HINTS_QUALITY.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        HINTS_SPEEDY.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        HINTS_QUALITY.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        HINTS_SPEEDY.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        HINTS_QUALITY.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        HINTS_SPEEDY.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        HINTS_QUALITY.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        HINTS_SPEEDY.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        HINTS_QUALITY.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        HINTS_SPEEDY.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        HINTS_QUALITY.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        HINTS_SPEEDY.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        HINTS_QUALITY.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        HINTS_SPEEDY.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        HINTS_QUALITY.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        HINTS_SPEEDY.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
    }
}

