/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import jp.sourceforge.jindolf.HttpUtils;
import jp.sourceforge.jindolf.Jindolf;

public class TallyOutputStream
extends OutputStream {
    private static final int BUFSIZE = 512;
    private final HttpURLConnection conn;
    private final OutputStream out;
    private long counter;
    private long nanoLap;

    public static OutputStream getOutputStream(HttpURLConnection conn) throws IOException {
        return new TallyOutputStream(conn);
    }

    protected TallyOutputStream(HttpURLConnection conn) throws IOException {
        this.conn = conn;
        this.counter = 0L;
        this.nanoLap = 0L;
        OutputStream os = this.conn.getOutputStream();
        this.out = os = new BufferedOutputStream(os, 512);
    }

    protected long getCount() {
        return this.counter;
    }

    public void close() throws IOException {
        this.out.close();
        long size = this.getCount();
        long span = System.nanoTime() - this.nanoLap;
        String message = HttpUtils.formatHttpStat(this.conn, size, span);
        Jindolf.logger.info(message);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(byte[] b) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(b);
        this.counter += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(b, off, len);
        this.counter += (long)len;
    }

    public void write(int b) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        this.out.write(b);
        ++this.counter;
    }
}

