/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.FaceIconSet;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.corelib.Destiny;
import jp.sourceforge.jindolf.corelib.GameRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WolfBBS {
    private static final String WIKICHAR = "#&[]()<>+-*:|~/,'%?";
    private static final Pattern WIKINAME_PATTERN = Pattern.compile("[A-Z][a-z]+([A-Z])[a-z]+");
    private static final String FACEICONSET = "resources/faceIconSet.properties";
    private static final String ORDER_PREFIX = "iconset.order.";
    private static final List<FaceIconSet> FACEICONSET_LIST = new LinkedList<FaceIconSet>();
    public static final String COMMENTLINE;
    private static final Charset CHARSET_EUC;
    private static final String WOLFBBS_URL = "http://wolfbbs.jp/";

    private static void loadFaceIconSet() {
        InputStream is = Jindolf.getResourceAsStream(FACEICONSET);
        Properties properties = new Properties();
        try {
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.SEVERE, "\u9854\u30a2\u30a4\u30b3\u30f3\u30bb\u30c3\u30c8\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            Jindolf.exit(1);
        }
        WolfBBS.loadFaceIconSet(properties);
    }

    private static void loadFaceIconSet(Properties properties) {
        String codeCheck = properties.getProperty("codeCheck");
        if (codeCheck == null || codeCheck.length() != 1 || codeCheck.charAt(0) != '\u72fc') {
            Jindolf.logger.severe("\u9854\u30a2\u30a4\u30b3\u30f3\u30bb\u30c3\u30c8\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u304a\u304b\u3057\u3044\u3088\u3046\u3067\u3059\u3002native2ascii \u306f\u6b63\u3057\u304f\u9069\u7528\u3057\u307e\u3057\u305f\u304b\uff1f");
            Jindolf.exit(1);
            return;
        }
        Set<Object> keySet = properties.keySet();
        TreeSet<Integer> orderSet = new TreeSet<Integer>();
        for (Object keyObj : keySet) {
            Integer order;
            String key;
            if (keyObj == null || !(key = keyObj.toString()).startsWith(ORDER_PREFIX)) continue;
            key = key.replace(ORDER_PREFIX, "");
            try {
                order = new Integer(key);
            }
            catch (NumberFormatException e) {
                continue;
            }
            orderSet.add(order);
        }
        for (Integer orderNum : orderSet) {
            String setName = properties.getProperty(ORDER_PREFIX + orderNum);
            FaceIconSet iconSet = WolfBBS.loadFaceIconSet(properties, setName);
            FACEICONSET_LIST.add(iconSet);
        }
    }

    private static FaceIconSet loadFaceIconSet(Properties properties, String setName) {
        String author = properties.getProperty(setName + ".author");
        String caption = properties.getProperty(setName + ".caption");
        String urlText = properties.getProperty(setName + ".url");
        FaceIconSet iconSet = new FaceIconSet(caption, author, urlText);
        SortedSet<Avatar> avatarSet = Avatar.getPredefinedAvatarSet();
        for (Avatar avatar : avatarSet) {
            String identifier = avatar.getIdentifier();
            String key = setName + ".iconWiki." + identifier;
            String wiki = properties.getProperty(key);
            iconSet.registIconWiki(avatar, wiki);
        }
        return iconSet;
    }

    public static List<FaceIconSet> getFaceIconSetList() {
        List<FaceIconSet> result = Collections.unmodifiableList(FACEICONSET_LIST);
        return result;
    }

    public static boolean isWikiChar(char ch) {
        return WIKICHAR.indexOf(ch) >= 0;
    }

    public static CharSequence escapeWikiChar(CharSequence seq) {
        StringBuilder result = new StringBuilder();
        int seqLength = seq.length();
        for (int pos = 0; pos < seqLength; ++pos) {
            char ch = seq.charAt(pos);
            if (WolfBBS.isWikiChar(ch)) {
                try {
                    WolfBBS.appendNumCharRef(result, ch);
                    continue;
                }
                catch (IOException e) {
                    assert (false);
                    return null;
                }
            }
            result.append(ch);
        }
        return result;
    }

    public static CharSequence escapeWikiName(CharSequence seq) {
        StringBuilder result = null;
        Matcher matcher = WIKINAME_PATTERN.matcher(seq);
        int pos = 0;
        while (matcher.find(pos)) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            int capStart = matcher.start(1);
            int capEnd = matcher.end(1);
            if (result == null) {
                result = new StringBuilder();
            }
            result.append(seq, pos, matchStart);
            result.append(seq, matchStart, capStart);
            try {
                WolfBBS.appendNumCharRef(result, seq.charAt(capStart));
            }
            catch (IOException e) {
                assert (false);
                return null;
            }
            result.append(seq, capEnd, matchEnd);
            pos = matchEnd;
        }
        if (pos == 0) {
            return seq;
        }
        result.append(seq, pos, seq.length());
        return result;
    }

    public static CharSequence escapeWikiSyntax(CharSequence seq) {
        CharSequence result = seq;
        result = WolfBBS.escapeWikiChar(result);
        result = WolfBBS.escapeWikiName(result);
        return result;
    }

    public static CharSequence escapeWikiBracket(CharSequence seq) {
        char ch;
        int pos;
        StringBuilder result = new StringBuilder();
        int seqLength = seq.length();
        for (int pos2 = 0; pos2 < seqLength; ++pos2) {
            char ch2 = seq.charAt(pos2);
            switch (ch2) {
                case '#': {
                    ch2 = '\uff03';
                    break;
                }
                case '&': {
                    ch2 = '\uff06';
                    break;
                }
                case '[': {
                    ch2 = '\uff3b';
                    break;
                }
                case ']': {
                    ch2 = '\uff3d';
                    break;
                }
                case '<': {
                    ch2 = '\uff1c';
                    break;
                }
                case '>': {
                    ch2 = '\uff1e';
                    break;
                }
            }
            result.append(ch2);
        }
        int resultLength = result.length();
        while (result.length() > 0 && result.charAt(0) == '/') {
            result.deleteCharAt(0);
        }
        resultLength = result.length();
        for (pos = resultLength - 1; pos >= 0 && (ch = result.charAt(pos)) == '/'; --pos) {
            result.deleteCharAt(pos);
        }
        resultLength = result.length();
        for (pos = 1; pos < resultLength - 1; ++pos) {
            ch = result.charAt(pos);
            if (ch != ':') continue;
            result.setCharAt(pos, '\uff1a');
        }
        resultLength = result.length();
        if (resultLength == 1 && result.charAt(0) == ':') {
            result.setCharAt(0, '\uff1a');
        }
        return result;
    }

    public static Appendable appendNumCharRef(Appendable app, char ch) throws IOException {
        app.append("&#x");
        char ival = ch;
        String hex = Integer.toHexString(ival);
        app.append(hex);
        app.append(';');
        return app;
    }

    public static CharSequence toNumCharRef(char ch) {
        StringBuilder result = new StringBuilder(8);
        try {
            WolfBBS.appendNumCharRef(result, ch);
        }
        catch (IOException e) {
            assert (false);
            return null;
        }
        return result;
    }

    public static String getTeamWikiColor(GameRole role) {
        String result;
        switch (role) {
            case INNOCENT: 
            case SEER: 
            case SHAMAN: 
            case HUNTER: 
            case FRATER: {
                result = "#b7bad3";
                break;
            }
            case WOLF: 
            case MADMAN: {
                result = "#e0b8b8";
                break;
            }
            case HAMSTER: {
                result = "#b9d0be";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    public static String getRoleIconWiki(GameRole role) {
        String name = role.getRoleName();
        String result = "&char(" + name + ");";
        return result;
    }

    public static String getDestinyColorWiki(Destiny destiny) {
        String result = destiny == Destiny.ALIVE ? "#ffffff" : "#aaaaaa";
        return result;
    }

    private static boolean isSimpleIdToken(char ch) {
        if ('0' <= ch && ch <= '9') {
            return true;
        }
        if ('A' <= ch && ch <= 'Z') {
            return true;
        }
        if ('a' <= ch && ch <= 'z') {
            return true;
        }
        return ch == '-' || ch == '_';
    }

    private static StringBuilder encodeId(StringBuilder seq, char ch) {
        ByteBuffer bytebuf;
        if (WolfBBS.isSimpleIdToken(ch)) {
            seq.append(ch);
            return seq;
        }
        CharBuffer cbuf = CharBuffer.allocate(1);
        cbuf.append(ch);
        cbuf.rewind();
        CharsetEncoder encoder = CHARSET_EUC.newEncoder();
        try {
            bytebuf = encoder.encode(cbuf);
        }
        catch (CharacterCodingException e) {
            seq.append('X');
            return seq;
        }
        int limit = bytebuf.limit();
        while (bytebuf.position() < limit) {
            int iVal = bytebuf.get();
            if (iVal < 0) {
                iVal += 256;
            }
            String hex = Integer.toHexString(iVal).toUpperCase(Locale.JAPAN);
            seq.append('%');
            if (hex.length() < 2) {
                seq.append('0');
            }
            seq.append(hex);
        }
        return seq;
    }

    private static StringBuilder encodeId(CharSequence id) {
        StringBuilder result = new StringBuilder();
        int length = id.length();
        for (int pt = 0; pt < length; ++pt) {
            char ch = id.charAt(pt);
            WolfBBS.encodeId(result, ch);
        }
        return result;
    }

    public static String encodeURLFromId(CharSequence id) {
        StringBuilder encodedId = WolfBBS.encodeId(id);
        String result = WOLFBBS_URL + encodedId + ".html";
        return result;
    }

    private WolfBBS() {
        assert (false);
        throw new AssertionError();
    }

    static {
        CHARSET_EUC = Charset.forName("EUC-JP");
        WolfBBS.loadFaceIconSet();
        StringBuilder wikicomment = new StringBuilder();
        wikicomment.append("// ");
        while (wikicomment.length() < 72) {
            wikicomment.append('=');
        }
        wikicomment.append('\n');
        COMMENTLINE = wikicomment.toString();
    }
}

