/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.corelib.PreDefAvatar;

public class AvatarData {
    private static final List<PreDefAvatar> PREDEF_AVATAR_LIST;
    private String fullName;
    private String shortName;
    private String avatarId;
    private String faceIconUri;

    public static PreDefAvatar getPreDefAvatar(CharSequence seq) {
        for (PreDefAvatar avatar : PREDEF_AVATAR_LIST) {
            String fullName = avatar.getFullName();
            if (!fullName.contentEquals(seq)) continue;
            return avatar;
        }
        return null;
    }

    public AvatarData() {
    }

    public AvatarData(PreDefAvatar predefAvatar) {
        this();
        this.fullName = predefAvatar.getFullName();
        this.shortName = predefAvatar.getShortName();
        this.avatarId = predefAvatar.getAvatarId();
        this.faceIconUri = null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(String avatarId) {
        this.avatarId = avatarId;
    }

    public String getFaceIconUri() {
        return this.faceIconUri;
    }

    public void setFaceIconUri(String faceIconUri) {
        this.faceIconUri = faceIconUri;
    }

    public void dumpXml(Writer writer) throws IOException {
        writer.append("<avatar\n");
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "avatarId", this.avatarId);
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "fullName", this.fullName);
        writer.append(' ');
        XmlUtils.attrOut(writer, "shortName", this.shortName);
        writer.append('\n');
        if (this.faceIconUri != null) {
            XmlUtils.indent(writer, 1);
            XmlUtils.attrOut(writer, "faceIconURI", this.faceIconUri);
            writer.append('\n');
        }
        writer.append("/>\n");
        writer.flush();
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            PREDEF_AVATAR_LIST = PreDefAvatar.buildPreDefAvatarList(builder);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

