/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import jp.sourceforge.jindolf.archiver.Handler;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.parser.ContentBuilder;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.HtmlParser;
import jp.sourceforge.jindolf.parser.SjisDecoder;

public final class Builder {
    public static DecodedContent contentFromStream(InputStream istream) throws IOException, DecodeException {
        SjisDecoder decoder = new SjisDecoder();
        ContentBuilder builder = new ContentBuilder();
        decoder.setDecodeHandler(builder);
        decoder.decode(istream);
        DecodedContent content = builder.getContent();
        return content;
    }

    public static void fillVillageData(VillageData villageData) throws IOException, DecodeException, HtmlParseException {
        HtmlParser parser = new HtmlParser();
        Handler handler = new Handler();
        parser.setBasicHandler(handler);
        parser.setTalkHandler(handler);
        parser.setSysEventHandler(handler);
        handler.initVillageData(villageData);
        for (PeriodResource resource : villageData.getPeriodResourceList()) {
            handler.initPeriodResource(resource);
            URL url = resource.getResourceUrl();
            if (url == null) {
                url = new URL(resource.getOrigUrlText());
            }
            URLConnection conn = url.openConnection();
            InputStream istream = conn.getInputStream();
            if (resource.getDownTimeMs() <= 0L) {
                long downTimeMs = conn.getDate();
                resource.setDownTimeMs(downTimeMs);
            }
            DecodedContent content = Builder.contentFromStream(istream);
            istream.close();
            parser.parseAutomatic(content);
        }
    }

    private Builder() {
    }
}

