/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jindolf.archiver.AvatarData;
import jp.sourceforge.jindolf.archiver.PeriodData;
import jp.sourceforge.jindolf.archiver.TopicData;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.parser.DecodedContent;

public class EventData
extends TopicData {
    private final PeriodData periodData;
    private SysEventType eventType = null;
    private final List<AvatarData> avatarList = new LinkedList<AvatarData>();
    private final List<Integer> intList = new LinkedList<Integer>();
    private final List<GameRole> roleList = new LinkedList<GameRole>();
    private final List<DecodedContent> strList = new LinkedList<DecodedContent>();

    public static String getTagName(SysEventType type) {
        String tagName;
        switch (type) {
            case STARTENTRY: {
                tagName = "startEntry";
                break;
            }
            case ONSTAGE: {
                tagName = "onStage";
                break;
            }
            case STARTMIRROR: {
                tagName = "startMirror";
                break;
            }
            case OPENROLE: {
                tagName = "openRole";
                break;
            }
            case MURDERED: {
                tagName = "murdered";
                break;
            }
            case STARTASSAULT: {
                tagName = "startAssault";
                break;
            }
            case SURVIVOR: {
                tagName = "survivor";
                break;
            }
            case COUNTING: {
                tagName = "counting";
                break;
            }
            case NOMURDER: {
                tagName = "noMurder";
                break;
            }
            case SUDDENDEATH: {
                tagName = "suddenDeath";
                break;
            }
            case WINVILLAGE: {
                tagName = "winVillage";
                break;
            }
            case WINWOLF: {
                tagName = "winWolf";
                break;
            }
            case WINHAMSTER: {
                tagName = "winHamster";
                break;
            }
            case PLAYERLIST: {
                tagName = "playerList";
                break;
            }
            case PANIC: {
                tagName = "panic";
                break;
            }
            case ASKENTRY: {
                tagName = "askEntry";
                break;
            }
            case ASKCOMMIT: {
                tagName = "askCommit";
                break;
            }
            case NOCOMMENT: {
                tagName = "noComment";
                break;
            }
            case STAYEPILOGUE: {
                tagName = "stayEpilogue";
                break;
            }
            case GAMEOVER: {
                tagName = "gameOver";
                break;
            }
            case GUARD: {
                tagName = "guard";
                break;
            }
            case JUDGE: {
                tagName = "judge";
                break;
            }
            case ASSAULT: {
                tagName = "assault";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return tagName;
    }

    public static String getRoleAttrValue(GameRole role) {
        String roleName;
        switch (role) {
            case INNOCENT: {
                roleName = "innocent";
                break;
            }
            case WOLF: {
                roleName = "wolf";
                break;
            }
            case SEER: {
                roleName = "seer";
                break;
            }
            case SHAMAN: {
                roleName = "shaman";
                break;
            }
            case MADMAN: {
                roleName = "madman";
                break;
            }
            case HUNTER: {
                roleName = "hunter";
                break;
            }
            case FRATER: {
                roleName = "frater";
                break;
            }
            case HAMSTER: {
                roleName = "hamster";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return roleName;
    }

    public static void dumpAvatarRef(Writer writer, AvatarData avatar) throws IOException {
        writer.append("<avatarRef");
        writer.append(' ');
        XmlUtils.attrOut(writer, "avatarId", avatar.getAvatarId());
        writer.append(" />\n");
    }

    public EventData(PeriodData periodData) {
        this.periodData = periodData;
    }

    public SysEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(SysEventType eventType) {
        this.eventType = eventType;
    }

    public void addAvatarData(AvatarData avatarData) {
        this.avatarList.add(avatarData);
    }

    public void addInteger(int intVal) {
        this.intList.add(intVal);
    }

    public void addGameRole(GameRole role) {
        this.roleList.add(role);
    }

    public void addDecodedContent(DecodedContent seq) {
        this.strList.add(seq);
    }

    public void dumpOnstageAttr(Writer writer) throws IOException {
        int entryNo = this.intList.get(0);
        AvatarData avatarData = this.avatarList.get(0);
        writer.append(' ');
        XmlUtils.attrOut(writer, "entryNo", Integer.toString(entryNo));
        writer.append(' ');
        XmlUtils.attrOut(writer, "avatarId", avatarData.getAvatarId());
    }

    public void dumpCountingAttr(Writer writer) throws IOException {
        int total = this.avatarList.size();
        if (total % 2 == 1) {
            AvatarData victim = this.avatarList.get(total - 1);
            writer.append(' ');
            XmlUtils.attrOut(writer, "victim", victim.getAvatarId());
        }
    }

    public void dumpSuddendeathAttr(Writer writer) throws IOException {
        AvatarData avatarData = this.avatarList.get(0);
        writer.append(' ');
        XmlUtils.attrOut(writer, "avatarId", avatarData.getAvatarId());
    }

    public void dumpAskEntryAttr(Writer writer) throws IOException {
        int hour = this.intList.get(0);
        int minute = this.intList.get(1);
        int minLimit = this.intList.get(2);
        int maxLimit = this.intList.get(3);
        writer.append(' ');
        XmlUtils.timeAttrOut(writer, "commitTime", hour, minute);
        writer.append(' ');
        XmlUtils.attrOut(writer, "minMembers", Integer.toString(minLimit));
        writer.append(' ');
        XmlUtils.attrOut(writer, "maxMembers", Integer.toString(maxLimit));
    }

    public void dumpAskCommitAttr(Writer writer) throws IOException {
        int hour = this.intList.get(0);
        int minute = this.intList.get(1);
        writer.append(' ');
        XmlUtils.timeAttrOut(writer, "limitVote", hour, minute);
        writer.append(' ');
        XmlUtils.timeAttrOut(writer, "limitSpecial", hour, minute);
    }

    public void dumpStayEpilogueAttr(Writer writer) throws IOException {
        String winner;
        GameRole role = this.roleList.get(0);
        int hour = this.intList.get(0);
        int minute = this.intList.get(1);
        switch (role) {
            case INNOCENT: {
                winner = "village";
                break;
            }
            case WOLF: {
                winner = "wolf";
                break;
            }
            case HAMSTER: {
                winner = "hamster";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        writer.append(' ');
        XmlUtils.attrOut(writer, "maxMembers", winner);
        writer.append(' ');
        XmlUtils.timeAttrOut(writer, "limitTime", hour, minute);
    }

    public void dumpOpenroleElem(Writer writer) throws IOException {
        int num = this.roleList.size();
        for (int index = 0; index < num; ++index) {
            int heads = this.intList.get(index);
            GameRole role = this.roleList.get(index);
            String roleName = EventData.getRoleAttrValue(role);
            writer.append("<roleHeads");
            writer.append(' ');
            XmlUtils.attrOut(writer, "role", roleName);
            writer.append(' ');
            XmlUtils.attrOut(writer, "heads", Integer.toString(heads));
            writer.append(" />\n");
        }
    }

    public void dumpMurderedElem(Writer writer) throws IOException {
        for (AvatarData avatar : this.avatarList) {
            EventData.dumpAvatarRef(writer, avatar);
        }
    }

    public void dumpSurvivorElem(Writer writer) throws IOException {
        for (AvatarData avatar : this.avatarList) {
            EventData.dumpAvatarRef(writer, avatar);
        }
    }

    public void dumpNoCommentElem(Writer writer) throws IOException {
        for (AvatarData avatar : this.avatarList) {
            EventData.dumpAvatarRef(writer, avatar);
        }
    }

    public void dumpCountingElem(Writer writer) throws IOException {
        int total = this.avatarList.size();
        total = total / 2 * 2;
        for (int index = 0; index < total; index += 2) {
            AvatarData voteBy = this.avatarList.get(index);
            AvatarData voteTo = this.avatarList.get(index + 1);
            writer.append("<vote");
            writer.append(' ');
            XmlUtils.attrOut(writer, "byWhom", voteBy.getAvatarId());
            writer.append(' ');
            XmlUtils.attrOut(writer, "target", voteTo.getAvatarId());
            writer.append(" />\n");
        }
    }

    public void dumpPlayerlistElem(Writer writer) throws IOException {
        int num = this.avatarList.size();
        for (int index = 0; index < num; ++index) {
            AvatarData avatar = this.avatarList.get(index);
            DecodedContent uri = this.strList.get(index * 2);
            DecodedContent account = this.strList.get(index * 2 + 1);
            int isLiving = this.intList.get(index);
            String survive = isLiving == 0 ? "false" : "true";
            GameRole role = this.roleList.get(index);
            String roleName = EventData.getRoleAttrValue(role);
            writer.append("<playerInfo");
            writer.append(' ');
            XmlUtils.attrOut(writer, "playerId", account.toString());
            writer.append(' ');
            XmlUtils.attrOut(writer, "avatarId", avatar.getAvatarId());
            writer.append(' ');
            XmlUtils.attrOut(writer, "survive", survive);
            writer.append(' ');
            XmlUtils.attrOut(writer, "role", roleName);
            String uriStr = uri.toString();
            uriStr = uriStr.replaceAll("^[\\s]+", "");
            uriStr = uriStr.replaceAll("[\\s]+$", "");
            uriStr = uriStr.replaceAll("[\\s]+", " ");
            if (uriStr.length() > 0) {
                writer.append(' ');
                XmlUtils.attrOut(writer, "uri", uriStr);
            }
            writer.append(" />\n");
        }
    }

    public void dumpByWhomAttr(Writer writer) throws IOException {
        AvatarData by = this.avatarList.get(0);
        AvatarData to = this.avatarList.get(1);
        writer.append(' ');
        XmlUtils.attrOut(writer, "byWhom", by.getAvatarId());
        writer.append(' ');
        XmlUtils.attrOut(writer, "target", to.getAvatarId());
    }

    public void dumpAssaultAttr(Writer writer) throws IOException {
        AvatarData by = this.avatarList.get(0);
        AvatarData to = this.avatarList.get(1);
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "byWhom", by.getAvatarId());
        writer.append(' ');
        XmlUtils.attrOut(writer, "target", to.getAvatarId());
        writer.append('\n');
        DecodedContent xname = this.strList.get(0);
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "xname", xname);
        int hour = this.intList.get(0);
        int minute = this.intList.get(1);
        writer.append(' ');
        XmlUtils.timeAttrOut(writer, "time", hour, minute);
        writer.append('\n');
        String icon = this.strList.get(1).toString();
        if (!icon.equals(by.getFaceIconUri())) {
            XmlUtils.indent(writer, 1);
            XmlUtils.attrOut(writer, "faceIconURI", icon);
            writer.append('\n');
        }
    }

    public void dumpXml(Writer writer) throws IOException {
        String tagName = EventData.getTagName(this.eventType);
        writer.append("<");
        writer.append(tagName);
        boolean hasAttr = true;
        switch (this.eventType) {
            case ONSTAGE: {
                this.dumpOnstageAttr(writer);
                break;
            }
            case COUNTING: {
                this.dumpCountingAttr(writer);
                break;
            }
            case SUDDENDEATH: {
                this.dumpSuddendeathAttr(writer);
                break;
            }
            case ASKENTRY: {
                this.dumpAskEntryAttr(writer);
                break;
            }
            case ASKCOMMIT: {
                this.dumpAskCommitAttr(writer);
                break;
            }
            case STAYEPILOGUE: {
                this.dumpStayEpilogueAttr(writer);
                break;
            }
            case GUARD: 
            case JUDGE: {
                this.dumpByWhomAttr(writer);
                break;
            }
            case ASSAULT: {
                this.dumpAssaultAttr(writer);
                break;
            }
            default: {
                hasAttr = false;
            }
        }
        if (hasAttr) {
            writer.append(' ');
        }
        writer.append(">\n");
        this.dumpLines(writer);
        switch (this.eventType) {
            case OPENROLE: {
                this.dumpOpenroleElem(writer);
                break;
            }
            case MURDERED: {
                this.dumpMurderedElem(writer);
                break;
            }
            case SURVIVOR: {
                this.dumpSurvivorElem(writer);
                break;
            }
            case COUNTING: {
                this.dumpCountingElem(writer);
                break;
            }
            case PLAYERLIST: {
                this.dumpPlayerlistElem(writer);
                break;
            }
            case NOCOMMENT: {
                this.dumpNoCommentElem(writer);
                break;
            }
        }
        writer.append("</");
        writer.append(tagName);
        writer.append(">\n");
    }
}

