/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sourceforge.jindolf.archiver.Builder;
import jp.sourceforge.jindolf.archiver.HttpAccess;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.ValidateTask;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.HtmlParseException;

public final class JinArchiver {
    public static final String GENERATOR = "JinArchiver 1.401.2";
    private static final List<LandDef> LANDDEF_LIST;

    public static LandDef getLandDef(String landId) {
        for (LandDef landDef : LANDDEF_LIST) {
            if (!landDef.getLandId().equals(landId)) continue;
            return landDef;
        }
        return null;
    }

    private static void helpMessage() {
        System.err.println("\nJinArchiver 1.401.2 \u4eba\u72fcBBS \u30a2\u30fc\u30ab\u30a4\u30d6\u4f5c\u6210\u30c4\u30fc\u30eb\n\n-h, -help, -?\n\t\u30d8\u30eb\u30d7\u30e1\u30c3\u30bb\u30fc\u30b8\n-land \u56fd\u8b58\u5225\u5b50\n-vid \u6751\u756a\u53f7\n-outdir \u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\n-stdout\n\t\u6a19\u6e96\u51fa\u529b\u3078\u51fa\u529b\n\n\u203b -outdir \u3068 -stdout \u306f\u6392\u4ed6\u6307\u5b9a\n");
        StringBuilder landList = new StringBuilder();
        for (LandDef landDef : LANDDEF_LIST) {
            landList.append(landDef.getLandId()).append(' ');
        }
        System.err.print("\u5229\u7528\u53ef\u80fd\u306a\u56fd\u8b58\u5225\u5b50\u306f ");
        System.err.println(landList);
        System.err.println();
    }

    private static void parseOption(String[] args) {
        if (args.length <= 0) {
            JinArchiver.helpMessage();
            System.exit(0);
            return;
        }
        LandDef landDef = null;
        int vid = -1;
        String outdir = null;
        boolean stdout = false;
        for (int pos = 0; pos < args.length; ++pos) {
            String arg = args[pos];
            if (!arg.startsWith("-")) {
                System.err.println("\u4e0d\u6b63\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u3059\u3002 " + arg);
                System.exit(1);
                return;
            }
            if (arg.equals("-h") || arg.equals("-help") || arg.equals("-?")) {
                JinArchiver.helpMessage();
                System.exit(0);
                return;
            }
            if (arg.equals("-stdout")) {
                stdout = true;
                outdir = null;
                continue;
            }
            if (++pos >= args.length) {
                System.err.println("\u30aa\u30d7\u30b7\u30e7\u30f3 " + arg + " \u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                System.exit(1);
                return;
            }
            String val = args[pos];
            if (arg.equals("-land")) {
                landDef = JinArchiver.getLandDef(val);
                if (landDef != null) continue;
                System.err.println("\u4e0d\u6b63\u306a\u56fd\u8b58\u5225\u5b50\u3067\u3059\u3002 " + val);
                System.exit(1);
                return;
            }
            if (arg.equals("-vid")) {
                vid = Integer.parseInt(val);
                if (vid >= 0) continue;
                System.err.println("\u4e0d\u6b63\u306a\u6751\u756a\u53f7\u3067\u3059\u3002 " + vid);
                System.exit(1);
                return;
            }
            if (arg.equals("-outdir")) {
                outdir = val;
                stdout = false;
                continue;
            }
            System.err.println("\u4e0d\u6b63\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u3059\u3002 " + arg);
            System.exit(1);
            return;
        }
        if (landDef == null) {
            System.err.println("-land \u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u56fd\u8b58\u5225\u5b50\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            System.exit(1);
            return;
        }
        if (vid < 0) {
            System.err.println("-vid \u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u6751\u756a\u53f7\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            System.exit(1);
            return;
        }
        if (outdir == null && !stdout || outdir != null && stdout) {
            System.err.println("-outdir \u304b -stdout \u306e\u3069\u3061\u3089\u304b\u4e00\u65b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            System.exit(1);
            return;
        }
        Writer writer = outdir != null ? JinArchiver.getFileWriter(outdir, landDef, vid) : JinArchiver.getStdOutWriter();
        writer = ValidateTask.wrapValidator(writer);
        try {
            JinArchiver.dump(writer, landDef, vid);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("\u51e6\u7406\u3092\u7d9a\u884c\u3067\u304d\u307e\u305b\u3093\u3002");
            System.exit(1);
            return;
        }
    }

    public static void dump(Writer writer, LandDef landDef, int vid) throws IOException, DecodeException, HtmlParseException {
        List<PeriodResource> resourceList = HttpAccess.loadResourceList(landDef, vid);
        VillageData village = new VillageData(resourceList);
        Builder.fillVillageData(village);
        XmlUtils.dumpVillageData(writer, village);
    }

    public static Writer getStdOutWriter() {
        Writer writer;
        BufferedOutputStream ostream = new BufferedOutputStream(System.out);
        try {
            writer = new OutputStreamWriter((OutputStream)ostream, "UTF-8");
            writer = new BufferedWriter(writer, 4096);
        }
        catch (IOException e) {
            System.err.println("\u6a19\u6e96\u51fa\u529b\u306b\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093\u3002");
            System.exit(1);
            return null;
        }
        return writer;
    }

    public static Writer getFileWriter(String outdir, LandDef landDef, int vid) {
        Writer writer;
        boolean created;
        File outFile = new File(outdir);
        if (!outFile.exists()) {
            System.err.println(outdir + " \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            System.exit(1);
            return null;
        }
        if (!outFile.isDirectory()) {
            System.err.println(outdir + " \u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            System.exit(1);
            return null;
        }
        if (!outFile.canWrite()) {
            System.err.println(outdir + " \u306b\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093\u3002");
            System.exit(1);
            return null;
        }
        String fname = MessageFormat.format("jin_{0}_{1,number,#00000}.xml", landDef.getLandId(), vid);
        File xmlFile = new File(outFile, fname);
        try {
            created = xmlFile.createNewFile();
        }
        catch (IOException e) {
            System.err.println(xmlFile.getName() + " \u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
            System.exit(1);
            return null;
        }
        if (!created) {
            System.err.println(fname + " \u304c\u65e2\u306b" + outdir + "\u306b\u5b58\u5728\u3057\u307e\u3059\u3002");
            System.exit(1);
            return null;
        }
        try {
            OutputStream ostream = new FileOutputStream(xmlFile);
            ostream = new BufferedOutputStream(ostream, 4096);
            writer = new OutputStreamWriter(ostream, "UTF-8");
            writer = new BufferedWriter(writer, 4096);
        }
        catch (IOException e) {
            System.err.println(xmlFile.getName() + " \u306b\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093\u3002");
            System.exit(1);
            return null;
        }
        return writer;
    }

    public static void main(String[] args) {
        JinArchiver.parseOption(args);
        System.exit(0);
    }

    private JinArchiver() {
        throw new Error();
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            LANDDEF_LIST = LandDef.buildLandDefList(builder);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

