/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPlexer
extends Writer {
    private final List<Writer> childs = new LinkedList<Writer>();

    public MultiPlexer() {
        this(null);
    }

    public MultiPlexer(Writer writer) {
        if (writer != null) {
            this.childs.add(writer);
        }
    }

    public void addWriter(Writer writer) {
        if (writer == null) {
            return;
        }
        this.childs.add(writer);
    }

    public List<Writer> getWriterList() {
        return Collections.unmodifiableList(this.childs);
    }

    @Override
    public void close() throws IOException {
        for (Writer writer : this.childs) {
            writer.close();
        }
    }

    @Override
    public void flush() throws IOException {
        for (Writer writer : this.childs) {
            writer.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (Writer writer : this.childs) {
            writer.write(cbuf, off, len);
        }
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        for (Writer writer : this.childs) {
            writer.append(csq);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        for (Writer writer : this.childs) {
            writer.append(csq, start, end);
        }
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        for (Writer writer : this.childs) {
            writer.append(c);
        }
        return this;
    }

    @Override
    public void write(int c) throws IOException {
        for (Writer writer : this.childs) {
            writer.write(c);
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        for (Writer writer : this.childs) {
            writer.write(cbuf);
        }
    }

    @Override
    public void write(String str) throws IOException {
        for (Writer writer : this.childs) {
            writer.write(str);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        for (Writer writer : this.childs) {
            writer.write(str, off, len);
        }
    }
}

