/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jindolf.archiver.EventData;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.TopicData;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.corelib.DisclosureType;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.parser.DecodedContent;

public class PeriodData {
    private final VillageData parent;
    private final PeriodResource resource;
    private DecodedContent loginName = new DecodedContent("");
    private int commitMonth;
    private int commitDay;
    private int commitHour;
    private int commitMinute;
    private DisclosureType disclosureType = DisclosureType.HOT;
    private boolean hasMurderResult = false;
    private final List<TopicData> topicList = new LinkedList<TopicData>();

    public PeriodData(VillageData parent, PeriodResource resource) {
        this.parent = parent;
        this.resource = resource;
    }

    public DecodedContent getLoginName() {
        return this.loginName;
    }

    public void setLoginName(DecodedContent loginName) {
        this.loginName = loginName;
    }

    public int getCommitMonth() {
        return this.commitMonth;
    }

    public void setCommitMonth(int commitMonth) {
        this.commitMonth = commitMonth;
    }

    public int getCommitDay() {
        return this.commitDay;
    }

    public void setCommitDay(int commitDay) {
        this.commitDay = commitDay;
    }

    public int getCommitHour() {
        return this.commitHour;
    }

    public void setCommitHour(int commitHour) {
        this.commitHour = commitHour;
    }

    public int getCommitMinute() {
        return this.commitMinute;
    }

    public void setCommitMinute(int commitMinute) {
        this.commitMinute = commitMinute;
    }

    public DisclosureType getDisclosureType() {
        return this.disclosureType;
    }

    public void setDisclosureType(DisclosureType type) {
        this.disclosureType = type;
    }

    public boolean hasMurderResult() {
        return this.hasMurderResult;
    }

    public void addTopicData(TopicData topicData) {
        EventData event;
        SysEventType type;
        this.topicList.add(topicData);
        if (topicData instanceof EventData && ((type = (event = (EventData)topicData).getEventType()) == SysEventType.MURDERED || type == SysEventType.NOMURDER)) {
            this.hasMurderResult = true;
        }
    }

    public void dumpXml(Writer writer) throws IOException {
        String ptype;
        writer.append("<period\n");
        switch (this.resource.getPeriodType()) {
            case PROLOGUE: {
                ptype = "prologue";
                break;
            }
            case PROGRESS: {
                ptype = "progress";
                break;
            }
            case EPILOGUE: {
                ptype = "epilogue";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "type", ptype);
        writer.append(' ');
        XmlUtils.attrOut(writer, "day", Integer.toString(this.resource.getDay()));
        writer.append('\n');
        if (this.disclosureType != DisclosureType.COMPLETE) {
            XmlUtils.indent(writer, 1);
            XmlUtils.attrOut(writer, "disclosure", this.disclosureType.getXmlName());
            writer.append('\n');
        }
        XmlUtils.indent(writer, 1);
        XmlUtils.dateAttrOut(writer, "nextCommitDay", this.commitMonth, this.commitDay);
        writer.append(' ');
        XmlUtils.timeAttrOut(writer, "commitTime", this.commitHour, this.commitMinute);
        writer.append('\n');
        URI baseUri = URI.create(this.parent.getBaseUri());
        URI periodUri = URI.create(this.resource.getOrigUrlText());
        URI relativeUri = baseUri.relativize(periodUri);
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "sourceURI", relativeUri.toString());
        writer.append('\n');
        long downTimeMs = this.resource.getDownTimeMs();
        XmlUtils.indent(writer, 1);
        XmlUtils.dateTimeAttr(writer, "loadedTime", downTimeMs);
        writer.append('\n');
        if (this.loginName.length() > 0) {
            XmlUtils.indent(writer, 1);
            XmlUtils.attrOut(writer, "loadedBy", this.loginName.toString());
            writer.append('\n');
        }
        writer.append(">\n\n");
        for (TopicData topic : this.topicList) {
            topic.dumpXml(writer);
            writer.append('\n');
            writer.flush();
        }
        writer.append("</period>\n");
    }
}

