/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.Writer;
import jp.sourceforge.jindolf.archiver.AvatarData;
import jp.sourceforge.jindolf.archiver.PeriodData;
import jp.sourceforge.jindolf.archiver.TopicData;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.corelib.TalkType;

public class TalkData
extends TopicData {
    private final PeriodData parent;
    private TalkType talkType = null;
    private AvatarData avatarData = null;
    private String xName;
    private String faceIconUri = null;
    private int hour;
    private int minute;

    public TalkData(PeriodData parent) {
        this.parent = parent;
    }

    public TalkType getTalkType() {
        return this.talkType;
    }

    public void setTalkType(TalkType talkType) {
        this.talkType = talkType;
    }

    public AvatarData getAvatarData() {
        return this.avatarData;
    }

    public void setAvatarData(AvatarData avatarData) {
        this.avatarData = avatarData;
    }

    public String getXName() {
        return this.xName;
    }

    public void setXName(String xName) {
        this.xName = xName;
    }

    public String getFaceIconUri() {
        return this.faceIconUri;
    }

    public void setFaceIconUri(String faceIconUri) {
        this.faceIconUri = faceIconUri;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public void dumpXml(Writer writer) throws IOException {
        String typeStr;
        writer.append("<talk\n");
        switch (this.talkType) {
            case PUBLIC: {
                typeStr = "public";
                break;
            }
            case WOLFONLY: {
                typeStr = "wolf";
                break;
            }
            case PRIVATE: {
                typeStr = "private";
                break;
            }
            case GRAVE: {
                typeStr = "grave";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "type", typeStr);
        writer.append(' ');
        XmlUtils.attrOut(writer, "avatarId", this.avatarData.getAvatarId());
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "xname", this.xName);
        writer.append(' ');
        XmlUtils.timeAttrOut(writer, "time", this.hour, this.minute);
        writer.append('\n');
        if (this.talkType != TalkType.GRAVE && !this.faceIconUri.equals(this.avatarData.getFaceIconUri())) {
            XmlUtils.indent(writer, 1);
            XmlUtils.attrOut(writer, "faceIconURI", this.faceIconUri);
            writer.append('\n');
        }
        writer.append(">\n");
        this.dumpLines(writer);
        writer.append("</talk>\n");
    }
}

