/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jindolf.archiver.AvatarData;
import jp.sourceforge.jindolf.archiver.PeriodData;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.corelib.DisclosureType;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.PreDefAvatar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VillageData {
    private final List<PeriodResource> resourceList;
    private final LandDef landDef;
    private final int villageId;
    private final String baseUri;
    private String fullName = "";
    private int commitHour = -1;
    private int commitMinute = -1;
    private String graveIconUri;
    private final List<AvatarData> avatarList = new LinkedList<AvatarData>();
    private int undefAvatarNo = 1;
    private final List<PeriodData> periodList = new LinkedList<PeriodData>();

    public static void validatePeriodResource(List<PeriodResource> list) throws IllegalArgumentException {
        LandDef landDef = null;
        int villageId = -1;
        int lastDay = -1;
        PeriodType periodType = null;
        for (PeriodResource resource : list) {
            if (landDef == null) {
                landDef = resource.getLandDef();
            } else if (resource.getLandDef() != landDef) {
                throw new IllegalArgumentException();
            }
            if (villageId < 0) {
                villageId = resource.getVillageId();
            } else if (resource.getVillageId() != villageId) {
                throw new IllegalArgumentException();
            }
            if (lastDay < 0) {
                lastDay = resource.getDay();
                if (lastDay != 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (resource.getDay() != lastDay + 1) {
                    throw new IllegalArgumentException();
                }
                lastDay = resource.getDay();
            }
            if (periodType == null) {
                periodType = resource.getPeriodType();
                if (periodType != PeriodType.PROLOGUE) {
                    throw new IllegalArgumentException();
                }
                if (lastDay == 0) continue;
                throw new IllegalArgumentException();
            }
            if (periodType == PeriodType.PROLOGUE) {
                periodType = resource.getPeriodType();
                if (periodType == PeriodType.PROGRESS) continue;
                throw new IllegalArgumentException();
            }
            if (periodType == PeriodType.PROGRESS) {
                periodType = resource.getPeriodType();
                continue;
            }
            if (periodType != PeriodType.EPILOGUE) continue;
            throw new IllegalArgumentException();
        }
        if (lastDay < 0) {
            throw new IllegalArgumentException();
        }
        if (periodType != PeriodType.EPILOGUE) {
            throw new IllegalArgumentException();
        }
    }

    public static String getBaseUri(List<PeriodResource> list) throws IllegalArgumentException {
        String result = null;
        for (PeriodResource resource : list) {
            String urlText = resource.getOrigUrlText();
            urlText = urlText.replaceAll("[^/]*$", "");
            if (result == null) {
                result = urlText;
                continue;
            }
            if (result.equals(urlText)) continue;
            throw new IllegalArgumentException();
        }
        return result;
    }

    public VillageData(List<PeriodResource> resourceList) {
        VillageData.validatePeriodResource(resourceList);
        this.resourceList = new LinkedList<PeriodResource>(resourceList);
        PeriodResource resource1st = this.resourceList.get(0);
        this.landDef = resource1st.getLandDef();
        this.villageId = resource1st.getVillageId();
        this.baseUri = VillageData.getBaseUri(this.resourceList);
    }

    public LandDef getLandDef() {
        return this.landDef;
    }

    public int getVillageId() {
        return this.villageId;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public int getCommitHour() {
        return this.commitHour;
    }

    public void setCommitHour(int commitHour) {
        this.commitHour = commitHour;
    }

    public int getCommitMinute() {
        return this.commitMinute;
    }

    public void setCommitMinute(int commitMinute) {
        this.commitMinute = commitMinute;
    }

    public String getGraveIconUri() {
        if (this.graveIconUri == null) {
            return this.landDef.getTombFaceIconURI().toASCIIString();
        }
        return this.graveIconUri;
    }

    public void setGraveIconUri(String graveIconUri) {
        this.graveIconUri = graveIconUri;
    }

    public DisclosureType getDisclosureType() {
        DisclosureType result = DisclosureType.COMPLETE;
        for (PeriodData period : this.periodList) {
            DisclosureType type = period.getDisclosureType();
            switch (type) {
                case HOT: {
                    return DisclosureType.HOT;
                }
                case UNCOMPLETE: {
                    result = DisclosureType.UNCOMPLETE;
                    break;
                }
            }
        }
        return result;
    }

    public void addPeriodData(PeriodData period) {
        this.periodList.add(period);
    }

    public List<PeriodResource> getPeriodResourceList() {
        return Collections.unmodifiableList(this.resourceList);
    }

    public AvatarData createAvatar(String avfullName) {
        AvatarData avatar = new AvatarData();
        avatar.setFullName(avfullName);
        String[] token = avfullName.split("\\s");
        String shortName = token[token.length - 1];
        avatar.setShortName(shortName);
        String avatarId = "ukavatar" + this.undefAvatarNo;
        ++this.undefAvatarNo;
        avatar.setAvatarId(avatarId);
        return avatar;
    }

    public AvatarData getAvatarData(CharSequence seq) {
        AvatarData avatar2;
        for (AvatarData avatar2 : this.avatarList) {
            String avfullName = avatar2.getFullName();
            if (!avfullName.contentEquals(seq)) continue;
            return avatar2;
        }
        PreDefAvatar predefAvatar = AvatarData.getPreDefAvatar(seq);
        if (predefAvatar != null) {
            avatar2 = new AvatarData(predefAvatar);
            this.avatarList.add(avatar2);
            return avatar2;
        }
        avatar2 = this.createAvatar(((Object)seq).toString());
        this.avatarList.add(avatar2);
        return avatar2;
    }

    public void dumpAvatarList(Writer writer) throws IOException {
        writer.append("<avatarList>").append("\n\n");
        for (AvatarData avatar : this.avatarList) {
            avatar.dumpXml(writer);
            writer.append('\n');
        }
        writer.append("</avatarList>").append('\n');
    }

    public void dumpPeriodList(Writer writer) throws IOException {
        for (PeriodData period : this.periodList) {
            period.dumpXml(writer);
            writer.append('\n');
        }
    }

    public void dumpXml(Writer writer) throws IOException {
        writer.append("<village\n");
        XmlUtils.indent(writer, 1);
        XmlUtils.dumpNameSpaceDecl(writer);
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.dumpSiNameSpaceDecl(writer);
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.dumpSchemeLocation(writer);
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "xml:lang", "ja-JP");
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "xml:base", this.baseUri);
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "fullName", this.fullName);
        writer.append(' ');
        XmlUtils.attrOut(writer, "vid", Integer.toString(this.villageId));
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.timeAttrOut(writer, "commitTime", this.commitHour, this.commitMinute);
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "state", "gameover");
        DisclosureType type = this.getDisclosureType();
        if (type != DisclosureType.COMPLETE) {
            writer.append(' ');
            XmlUtils.attrOut(writer, "disclosure", type.getXmlName());
        }
        String isValid = this.landDef.isValidVillageId(this.villageId) ? "true" : "false";
        writer.append(' ');
        XmlUtils.attrOut(writer, "isValid", isValid);
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "landName", this.landDef.getLandName());
        writer.append(' ');
        XmlUtils.attrOut(writer, "formalName", this.landDef.getFormalName());
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "landId", this.landDef.getLandId());
        writer.append(' ');
        XmlUtils.attrOut(writer, "landPrefix", this.landDef.getLandPrefix());
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        String locale = this.landDef.getLocale().toString();
        locale = locale.replaceAll("_", "-");
        XmlUtils.attrOut(writer, "locale", locale);
        writer.append(' ');
        XmlUtils.attrOut(writer, "origencoding", this.landDef.getEncoding().name());
        writer.append(' ');
        XmlUtils.attrOut(writer, "timezone", this.landDef.getTimeZone().getID());
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "graveIconURI", this.getGraveIconUri());
        writer.append('\n');
        XmlUtils.indent(writer, 1);
        XmlUtils.attrOut(writer, "generator", "JinArchiver 1.401.2");
        writer.append('\n');
        writer.append(">").append('\n');
        writer.append('\n');
        this.dumpAvatarList(writer);
        writer.append('\n');
        this.dumpPeriodList(writer);
        writer.append("</village>").append("\n");
    }
}

