/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.jindolf.json.AbstractJsValue;
import jp.sourceforge.jindolf.json.JsParseException;
import jp.sourceforge.jindolf.json.JsValue;
import jp.sourceforge.jindolf.json.JsVisitException;
import jp.sourceforge.jindolf.json.Json;
import jp.sourceforge.jindolf.json.JsonReader;
import jp.sourceforge.jindolf.json.ValueVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsArray
extends AbstractJsValue
implements Iterable<JsValue> {
    private final List<JsValue> valueList = new ArrayList<JsValue>();
    private boolean changed = false;

    public static JsArray parseArray(JsonReader reader) throws IOException, JsParseException {
        Json.skipWhiteSpace(reader);
        int chData = reader.read();
        if (chData < 0) {
            return null;
        }
        if (chData != 91) {
            throw new JsParseException();
        }
        JsArray result = new JsArray();
        while (true) {
            Json.skipWhiteSpace(reader);
            chData = reader.read();
            if (chData < 0) {
                throw new JsParseException();
            }
            if (chData == 93) break;
            if (result.size() <= 0) {
                reader.unread(chData);
            } else {
                if (chData != 44) {
                    throw new JsParseException();
                }
                Json.skipWhiteSpace(reader);
            }
            JsValue value = Json.parseValue(reader);
            if (value == null) {
                throw new JsParseException();
            }
            result.add(value);
        }
        return result;
    }

    public void add(JsValue value) {
        this.valueList.add(value);
        this.changed = true;
    }

    public JsValue get(int index) throws IndexOutOfBoundsException {
        return this.valueList.get(index);
    }

    public void clear() {
        if (this.valueList.size() > 0) {
            this.changed = true;
        }
        this.valueList.clear();
    }

    public boolean remove(JsValue value) {
        boolean removed = this.valueList.remove(value);
        if (removed) {
            this.changed = true;
        }
        return removed;
    }

    public int size() {
        return this.valueList.size();
    }

    @Override
    public Iterator<JsValue> iterator() {
        Collection<JsValue> unmodColl = Collections.unmodifiableCollection(this.valueList);
        return unmodColl.iterator();
    }

    public int hashCode() {
        return ((Object)this.valueList).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsArray)) {
            return false;
        }
        JsArray array = (JsArray)obj;
        return ((Object)this.valueList).equals(array.valueList);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("[");
        boolean hasElem = false;
        for (JsValue value : this.valueList) {
            if (hasElem) {
                text.append(',');
            }
            text.append(value);
            hasElem = true;
        }
        text.append("]");
        return text.toString();
    }

    @Override
    public void traverse(ValueVisitor visitor) throws JsVisitException {
        visitor.visitValue(this);
        for (JsValue value : this.valueList) {
            value.traverse(visitor);
        }
        visitor.visitCollectionClose(this);
    }

    @Override
    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (JsValue value : this.valueList) {
            if (!value.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUnchanged() {
        this.changed = false;
        for (JsValue value : this.valueList) {
            value.setUnchanged();
        }
    }
}

