/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jp.sourceforge.jindolf.json.AbstractJsValue;
import jp.sourceforge.jindolf.json.JsParseException;
import jp.sourceforge.jindolf.json.Json;
import jp.sourceforge.jindolf.json.JsonReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsNumber
extends AbstractJsValue
implements Comparable<JsNumber> {
    private BigDecimal decimal;

    public static Appendable appendDigitText(JsonReader reader, Appendable app) throws IOException, JsParseException {
        int chData = reader.read();
        if (chData < 0) {
            throw new JsParseException();
        }
        if (chData == 45) {
            app.append('-');
        } else if (chData != 43) {
            reader.unread(chData);
        }
        boolean hasAppended = false;
        while (true) {
            if ((chData = reader.read()) < 0) {
                throw new JsParseException();
            }
            if (48 > chData || chData > 57) break;
            app.append((char)chData);
            hasAppended = true;
        }
        if (!hasAppended) {
            throw new JsParseException();
        }
        reader.unread(chData);
        return app;
    }

    public static Appendable appendIntegerPart(JsonReader reader, Appendable app) throws IOException, JsParseException {
        int chData = reader.read();
        if (chData < 0) {
            throw new JsParseException();
        }
        if (chData == 43) {
            throw new JsParseException();
        }
        reader.unread(chData);
        JsNumber.appendDigitText(reader, app);
        return app;
    }

    public static Appendable appendFractionPart(JsonReader reader, Appendable app) throws IOException, JsParseException {
        int chData = reader.read();
        if (chData < 0) {
            throw new JsParseException();
        }
        if (chData != 46) {
            reader.unread(chData);
            return app;
        }
        app.append(".");
        boolean hasAppended = false;
        while (true) {
            if ((chData = reader.read()) < 0) {
                throw new JsParseException();
            }
            if (48 > chData || chData > 57) break;
            app.append((char)chData);
            hasAppended = true;
        }
        if (!hasAppended) {
            throw new JsParseException();
        }
        reader.unread(chData);
        return app;
    }

    public static Appendable appendExpPart(JsonReader reader, Appendable app) throws IOException, JsParseException {
        int chData = reader.read();
        if (chData < 0) {
            throw new JsParseException();
        }
        if (chData != 101 && chData != 69) {
            reader.unread(chData);
            return app;
        }
        app.append('E');
        JsNumber.appendDigitText(reader, app);
        return app;
    }

    public static JsNumber parseNumber(JsonReader reader) throws IOException, JsParseException {
        Json.skipWhiteSpace(reader);
        StringBuilder numText = new StringBuilder();
        JsNumber.appendIntegerPart(reader, numText);
        JsNumber.appendFractionPart(reader, numText);
        JsNumber.appendExpPart(reader, numText);
        JsNumber result = new JsNumber(numText);
        return result;
    }

    public JsNumber(long val) {
        this(BigDecimal.valueOf(val));
    }

    public JsNumber(double val) {
        this(BigDecimal.valueOf(val));
    }

    public JsNumber(BigInteger val) {
        this(new BigDecimal(val));
    }

    public JsNumber(CharSequence val) throws NumberFormatException {
        this(new BigDecimal(((Object)val).toString()));
    }

    public JsNumber(BigDecimal val) throws NullPointerException {
        if (val == null) {
            throw new NullPointerException();
        }
        this.decimal = val;
    }

    public BigDecimal getBigDecimal() {
        return this.decimal;
    }

    public int intValue() {
        return this.decimal.intValue();
    }

    public long longValue() {
        return this.decimal.longValue();
    }

    public float floatValue() {
        return this.decimal.floatValue();
    }

    public double doubleValue() {
        return this.decimal.doubleValue();
    }

    public int hashCode() {
        return this.decimal.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsNumber)) {
            return false;
        }
        JsNumber number = (JsNumber)obj;
        return this.decimal.equals(number.decimal);
    }

    @Override
    public int compareTo(JsNumber value) {
        if (this == value) {
            return 0;
        }
        return this.decimal.compareTo(value.decimal);
    }

    public String toString() {
        return this.decimal.toString();
    }
}

