/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.sourceforge.jindolf.json.AbstractJsValue;
import jp.sourceforge.jindolf.json.JsPair;
import jp.sourceforge.jindolf.json.JsParseException;
import jp.sourceforge.jindolf.json.JsString;
import jp.sourceforge.jindolf.json.JsValue;
import jp.sourceforge.jindolf.json.JsVisitException;
import jp.sourceforge.jindolf.json.Json;
import jp.sourceforge.jindolf.json.JsonReader;
import jp.sourceforge.jindolf.json.ValueVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsObject
extends AbstractJsValue
implements Iterable<JsPair> {
    private final Map<String, JsValue> valueMap = new TreeMap<String, JsValue>();
    private boolean changed = false;

    public static JsObject parseObject(JsonReader reader) throws IOException, JsParseException {
        Json.skipWhiteSpace(reader);
        int chData = reader.read();
        if (chData < 0) {
            return null;
        }
        if (chData != 123) {
            throw new JsParseException();
        }
        JsObject result = new JsObject();
        while (true) {
            Json.skipWhiteSpace(reader);
            chData = reader.read();
            if (chData < 0) {
                throw new JsParseException();
            }
            if (chData == 125) break;
            if (result.size() <= 0) {
                reader.unread(chData);
            } else {
                if (chData != 44) {
                    throw new JsParseException();
                }
                Json.skipWhiteSpace(reader);
            }
            JsString name = JsString.parseString(reader);
            if (name == null) {
                throw new JsParseException();
            }
            Json.skipWhiteSpace(reader);
            chData = reader.read();
            if (chData < 0) {
                throw new JsParseException();
            }
            if (chData != 58) {
                throw new JsParseException();
            }
            Json.skipWhiteSpace(reader);
            JsValue value = Json.parseValue(reader);
            if (value == null) {
                throw new JsParseException();
            }
            result.putValue(name.toRawString(), value);
        }
        return result;
    }

    public JsValue putValue(String name, JsValue value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        JsValue oldValue = this.valueMap.get(name);
        if (value.equals(oldValue)) {
            return null;
        }
        JsValue old = this.valueMap.put(name, value);
        this.changed = true;
        return old;
    }

    public JsValue getValue(String name) {
        return this.valueMap.get(name);
    }

    public void putPair(JsPair pair) {
        this.putValue(pair.getName(), pair.getValue());
    }

    public JsPair getPair(String name) {
        JsValue value = this.getValue(name);
        if (value == null) {
            return null;
        }
        return new JsPair(name, value);
    }

    public void clear() {
        if (this.valueMap.size() > 0) {
            this.changed = true;
        }
        this.valueMap.clear();
    }

    public JsValue remove(String name) {
        JsValue old = this.valueMap.remove(name);
        if (old != null) {
            this.changed = true;
        }
        return old;
    }

    public Set<String> nameSet() {
        return this.valueMap.keySet();
    }

    public List<JsPair> getPairList() {
        ArrayList<JsPair> result = new ArrayList<JsPair>();
        for (String name : this.nameSet()) {
            JsPair pair = this.getPair(name);
            result.add(pair);
        }
        return result;
    }

    @Override
    public Iterator<JsPair> iterator() {
        return this.getPairList().iterator();
    }

    public int size() {
        return this.valueMap.size();
    }

    public int hashCode() {
        return ((Object)this.valueMap).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsObject)) {
            return false;
        }
        JsObject composit = (JsObject)obj;
        return ((Object)this.valueMap).equals(composit.valueMap);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("{");
        boolean hasElem = false;
        for (JsPair pair : this) {
            block4: {
                if (hasElem) {
                    text.append(',');
                }
                try {
                    JsString.writeText(text, pair.getName());
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            text.append(':').append(pair.getValue());
            hasElem = true;
        }
        text.append("}");
        return text.toString();
    }

    @Override
    public void traverse(ValueVisitor visitor) throws JsVisitException {
        visitor.visitValue(this);
        for (JsPair pair : this) {
            String name = pair.getName();
            JsValue value = pair.getValue();
            visitor.visitPairName(name);
            value.traverse(visitor);
        }
        visitor.visitCollectionClose(this);
    }

    @Override
    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (JsValue value : this.valueMap.values()) {
            if (!value.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUnchanged() {
        this.changed = false;
        for (JsValue value : this.valueMap.values()) {
            value.setUnchanged();
        }
    }
}

