/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.json;

import java.io.IOException;
import jp.sourceforge.jindolf.json.AbstractJsValue;
import jp.sourceforge.jindolf.json.JsParseException;
import jp.sourceforge.jindolf.json.Json;
import jp.sourceforge.jindolf.json.JsonReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsString
extends AbstractJsValue
implements CharSequence,
Comparable<JsString> {
    private final String text;

    public static char parseHexChar(JsonReader reader) throws IOException, JsParseException {
        int hex1 = reader.read();
        int hex2 = reader.read();
        int hex3 = reader.read();
        int hex4 = reader.read();
        if (hex4 < 0) {
            throw new JsParseException();
        }
        char hex1Ch = (char)hex1;
        char hex2Ch = (char)hex2;
        char hex3Ch = (char)hex3;
        char hex4Ch = (char)hex4;
        int digit1 = Character.digit(hex1Ch, 16);
        int digit2 = Character.digit(hex2Ch, 16);
        int digit3 = Character.digit(hex3Ch, 16);
        int digit4 = Character.digit(hex4Ch, 16);
        if (digit1 < 0) {
            throw new JsParseException();
        }
        if (digit2 < 0) {
            throw new JsParseException();
        }
        if (digit3 < 0) {
            throw new JsParseException();
        }
        if (digit4 < 0) {
            throw new JsParseException();
        }
        int digit = 0;
        digit += digit1;
        digit <<= 4;
        digit += digit2;
        digit <<= 4;
        digit += digit3;
        digit <<= 4;
        char result = (char)(digit += digit4);
        return result;
    }

    public static JsString parseString(JsonReader reader) throws IOException, JsParseException {
        Json.skipWhiteSpace(reader);
        int chData = reader.read();
        if (chData < 0) {
            return null;
        }
        if (chData != 34) {
            throw new JsParseException();
        }
        StringBuilder text = new StringBuilder();
        while (true) {
            if ((chData = reader.read()) < 0) {
                throw new JsParseException();
            }
            if (chData == 34) break;
            if (chData == 92) {
                chData = reader.read();
                if (chData < 0) {
                    throw new JsParseException();
                }
                if (chData == 34) {
                    text.append('\"');
                    continue;
                }
                if (chData == 92) {
                    text.append('\\');
                    continue;
                }
                if (chData == 47) {
                    text.append('/');
                    continue;
                }
                if (chData == 98) {
                    text.append('\b');
                    continue;
                }
                if (chData == 102) {
                    text.append('\f');
                    continue;
                }
                if (chData == 110) {
                    text.append('\n');
                    continue;
                }
                if (chData == 114) {
                    text.append('\r');
                    continue;
                }
                if (chData == 116) {
                    text.append('\t');
                    continue;
                }
                if (chData == 117) {
                    text.append(JsString.parseHexChar(reader));
                    continue;
                }
                throw new JsParseException();
            }
            text.append((char)chData);
        }
        JsString result = new JsString(text);
        return result;
    }

    public static void writeText(Appendable appout, CharSequence seq) throws IOException {
        appout.append('\"');
        int length = seq.length();
        block10: for (int pos = 0; pos < length; ++pos) {
            char ch = seq.charAt(pos);
            switch (ch) {
                case '\"': {
                    appout.append('\\').append('\"');
                    continue block10;
                }
                case '\\': {
                    appout.append('\\').append('\\');
                    continue block10;
                }
                case '/': {
                    appout.append('\\').append('/');
                    continue block10;
                }
                case '\b': {
                    appout.append('\\').append('b');
                    continue block10;
                }
                case '\f': {
                    appout.append('\\').append('f');
                    continue block10;
                }
                case '\n': {
                    appout.append('\\').append('n');
                    continue block10;
                }
                case '\r': {
                    appout.append('\\').append('r');
                    continue block10;
                }
                case '\t': {
                    appout.append('\\').append('t');
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String hex = "0000" + Integer.toHexString(ch);
                        hex = hex.substring(hex.length() - 4);
                        appout.append("\\u").append(hex);
                        continue block10;
                    }
                    appout.append(ch);
                }
            }
        }
        appout.append('\"');
    }

    public JsString() {
        this(null);
    }

    public JsString(CharSequence seq) {
        this.text = seq == null ? "" : ((Object)seq).toString();
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.text.charAt(index);
    }

    @Override
    public int length() {
        return this.text.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.text.subSequence(start, end);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsString)) {
            return false;
        }
        JsString string = (JsString)obj;
        return this.text.equals(string.text);
    }

    @Override
    public int compareTo(JsString value) {
        if (this == value) {
            return 0;
        }
        return this.text.compareTo(value.text);
    }

    @Override
    public String toString() {
        StringBuilder string;
        block2: {
            string = new StringBuilder();
            try {
                JsString.writeText(string, this.text);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return string.toString();
    }

    public String toRawString() {
        return this.text;
    }
}

