/*
 * 矩形領域テキスト描画抽象クラス
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: AbstractTextRow.java 888 2009-11-04 06:23:35Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;

/**
 * TextRowの実装を助けるクラス。
 */
public abstract class AbstractTextRow implements TextRow{

    /** 描画領域矩形。 */
    protected final Rectangle bounds = new Rectangle();
    /** フォント指定。 */
    protected Font font = GUIUtils.DEFAULT_FONT;
    /** フォント描画指定。 */
    protected FontRenderContext renderContext = GUIUtils.DEFAULT_FRC;

    private boolean visible = true;

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public Rectangle getBounds(){
        return this.bounds;
    }

    /**
     * {@inheritDoc}
     * @param xPos {@inheritDoc}
     * @param yPos {@inheritDoc}
     */
    public void setPos(int xPos, int yPos){
        this.bounds.x = xPos;
        this.bounds.y = yPos;
        return;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public int getWidth(){
        return this.bounds.width;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public int getHeight(){
        return this.bounds.height;
    }

    /**
     * {@inheritDoc}
     * @param newFont {@inheritDoc}
     * @param newRenderContext {@inheritDoc}
     */
    public void setFontInfo(Font newFont,
                              FontRenderContext newRenderContext ){
        this.font = newFont;
        this.renderContext = newRenderContext;
        return;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    public boolean isVisible(){
        return this.visible;
    }

    /**
     * {@inheritDoc}
     * @param visible {@inheritDoc}
     */
    public void setVisible(boolean visible){
        this.visible = visible;
        return;
    }

}
