/*
 * JSON null value
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: JsNull.java 900 2009-11-16 15:48:22Z olyutorskii $
 */

package jp.sourceforge.jindolf.json;

/**
 * JSON Null Value。
 * その実体はシングルトン
 */
public final class JsNull
        extends AbstractJsValue
        implements Comparable<JsNull> {

    /** ただ唯一のインスタンス。 */
    public static final JsNull NULL = new JsNull();

    /**
     * 隠しコンストラクタ。
     * 1回しか呼ばれないはず
     */
    private JsNull(){
        super();
        return;
    }

    /**
     * {@inheritDoc}
     * @param value {@inheritDoc}
     * @return {@inheritDoc}
     */
    public int compareTo(JsNull value){
        if(value == null) throw new NullPointerException();
        return 0;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    @Override
    public String toString(){
        return "null";
    }

}
