/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.text.CharacterIterator;
import jp.sourceforge.jindolf.FontInfo;
import jp.sourceforge.jindolf.TextRow;

public abstract class AbstractTextRow
implements TextRow {
    protected final Rectangle bounds = new Rectangle();
    protected FontInfo fontInfo;
    private boolean visible = true;

    protected AbstractTextRow() {
        this(FontInfo.DEFAULT_FONTINFO);
    }

    protected AbstractTextRow(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setPos(int xPos, int yPos) {
        this.bounds.x = xPos;
        this.bounds.y = yPos;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public GlyphVector createGlyphVector(CharacterIterator iterator) {
        Font font = this.fontInfo.getFont();
        FontRenderContext context = this.fontInfo.getFontRenderContext();
        GlyphVector glyph = font.createGlyphVector(context, iterator);
        return glyph;
    }
}

