/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.File;
import jp.sourceforge.jindolf.CmdOption;
import jp.sourceforge.jindolf.ConfigFile;
import jp.sourceforge.jindolf.FileUtils;
import jp.sourceforge.jindolf.FontInfo;
import jp.sourceforge.jindolf.OptionInfo;
import jp.sourceforge.jindolf.ProxyInfo;
import jp.sourceforge.jindolf.json.JsObject;
import jp.sourceforge.jindolf.json.JsValue;

public class AppSetting {
    private static final String NETCONFIG_FILE = "netconfig.json";
    private static final String HASH_PROXY = "proxy";
    private static final String TALKCONFIG_FILE = "talkconfig.json";
    private static final String HASH_FONT = "font";
    private OptionInfo optInfo;
    private boolean useConfigPath;
    private File configPath;
    private FontInfo fontInfo = FontInfo.DEFAULT_FONTINFO;
    private int frameWidth = 800;
    private int frameHeight = 600;
    private int frameXpos = Integer.MIN_VALUE;
    private int frameYpos = Integer.MIN_VALUE;
    private ProxyInfo proxyInfo = ProxyInfo.DEFAULT;
    private JsValue loadedNetConfig;
    private JsValue loadedTalkConfig;

    public void applyOptionInfo(OptionInfo optionInfo) {
        this.optInfo = optionInfo;
        this.applyConfigPathSetting();
        this.applyFontSetting();
        this.applyGeometrySetting();
    }

    private void applyConfigPathSetting() {
        CmdOption opt = this.optInfo.getExclusiveOption(CmdOption.OPT_CONFDIR, CmdOption.OPT_NOCONF);
        if (opt == CmdOption.OPT_NOCONF) {
            this.useConfigPath = false;
            this.configPath = null;
        } else if (opt == CmdOption.OPT_CONFDIR) {
            this.useConfigPath = true;
            String path = this.optInfo.getStringArg(CmdOption.OPT_CONFDIR);
            this.configPath = FileUtils.supplyFullPath(new File(path));
        } else {
            File path;
            this.useConfigPath = true;
            this.configPath = path = ConfigFile.getImplicitConfigDirectory();
        }
    }

    private void applyFontSetting() {
        FontRenderContext newContext;
        FontRenderContext context;
        String fontName = this.optInfo.getStringArg(CmdOption.OPT_INITFONT);
        Boolean useAntiAlias = this.optInfo.getBooleanArg(CmdOption.OPT_ANTIALIAS);
        Boolean useFractional = this.optInfo.getBooleanArg(CmdOption.OPT_FRACTIONAL);
        if (fontName != null) {
            Font font = Font.decode(fontName);
            this.fontInfo = this.fontInfo.deriveFont(font);
        }
        if (useAntiAlias != null) {
            context = this.fontInfo.getFontRenderContext();
            newContext = new FontRenderContext(context.getTransform(), useAntiAlias, context.usesFractionalMetrics());
            this.fontInfo = this.fontInfo.deriveRenderContext(newContext);
        }
        if (useFractional != null) {
            context = this.fontInfo.getFontRenderContext();
            newContext = new FontRenderContext(context.getTransform(), context.isAntiAliased(), useFractional);
            this.fontInfo = this.fontInfo.deriveRenderContext(newContext);
        }
    }

    private void applyGeometrySetting() {
        Integer ival = this.optInfo.initialFrameWidth();
        if (ival != null) {
            this.frameWidth = ival;
        }
        if ((ival = this.optInfo.initialFrameHeight()) != null) {
            this.frameHeight = ival;
        }
        if ((ival = this.optInfo.initialFrameXpos()) != null) {
            this.frameXpos = ival;
        }
        if ((ival = this.optInfo.initialFrameYpos()) != null) {
            this.frameYpos = ival;
        }
    }

    public File getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(File path) {
        this.configPath = path;
    }

    public boolean useConfigPath() {
        return this.useConfigPath;
    }

    public void setUseConfigPath(boolean need) {
        this.useConfigPath = need;
    }

    public int initialFrameWidth() {
        return this.frameWidth;
    }

    public int initialFrameHeight() {
        return this.frameHeight;
    }

    public int initialFrameXpos() {
        return this.frameXpos;
    }

    public int initialFrameYpos() {
        return this.frameYpos;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo == null ? ProxyInfo.DEFAULT : proxyInfo;
    }

    private void loadNetConfig() {
        if (!this.useConfigPath()) {
            return;
        }
        JsValue value = ConfigFile.loadJson(new File(NETCONFIG_FILE));
        if (value == null) {
            return;
        }
        this.loadedNetConfig = value;
        if (!(value instanceof JsObject)) {
            return;
        }
        JsObject root = (JsObject)value;
        if (!((value = root.getValue(HASH_PROXY)) instanceof JsObject)) {
            return;
        }
        JsObject proxy = (JsObject)value;
        ProxyInfo info = ProxyInfo.decodeJson(proxy);
        this.setProxyInfo(info);
    }

    private void loadTalkConfig() {
        if (!this.useConfigPath()) {
            return;
        }
        JsValue value = ConfigFile.loadJson(new File(TALKCONFIG_FILE));
        if (value == null) {
            return;
        }
        this.loadedTalkConfig = value;
        if (!(value instanceof JsObject)) {
            return;
        }
        JsObject root = (JsObject)value;
        if (!((value = root.getValue(HASH_FONT)) instanceof JsObject)) {
            return;
        }
        JsObject font = (JsObject)value;
        FontInfo info = FontInfo.decodeJson(font);
        this.setFontInfo(info);
        this.applyFontSetting();
    }

    private void saveNetConfig() {
        if (!this.useConfigPath()) {
            return;
        }
        JsObject root = new JsObject();
        JsObject proxy = ProxyInfo.buildJson(this.getProxyInfo());
        root.putValue(HASH_PROXY, proxy);
        if (this.loadedNetConfig != null && this.loadedNetConfig.equals(root)) {
            return;
        }
        ConfigFile.saveJson(new File(NETCONFIG_FILE), root);
    }

    private void saveTalkConfig() {
        if (!this.useConfigPath()) {
            return;
        }
        JsObject root = new JsObject();
        JsObject font = FontInfo.buildJson(this.getFontInfo());
        root.putValue(HASH_FONT, font);
        if (this.loadedTalkConfig != null && this.loadedTalkConfig.equals(root)) {
            return;
        }
        ConfigFile.saveJson(new File(TALKCONFIG_FILE), root);
    }

    public void loadConfig() {
        this.loadNetConfig();
        this.loadTalkConfig();
    }

    public void saveConfig() {
        this.saveNetConfig();
        this.saveTalkConfig();
    }
}

