/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.File;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.sourceforge.jindolf.Jindolf;

public final class EnvInfo {
    private static final Map<String, String> propertyMap = new TreeMap<String, String>();
    private static final String osName;
    private static final String osVersion;
    private static final String osArch;
    private static final String javaVendor;
    private static final String javaVersion;
    private static final String classpath;
    private static final String[] classpaths;
    private static final Map<String, String> environmentMap;
    private static final String envLANG;
    private static final String envDISPLAY;

    public static String getOsName() {
        return osName;
    }

    public static String getOsArch() {
        return osArch;
    }

    public static String getOsVersion() {
        return osVersion;
    }

    public static String getJavaVendor() {
        return javaVendor;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static String getClasspath() {
        return classpath;
    }

    public static String[] getClasspaths() {
        return classpaths;
    }

    public static String getEnvLANG() {
        return envLANG;
    }

    public static String getEnvDISPLAY() {
        return envDISPLAY;
    }

    private static String getSecureProperty(String key) {
        String result;
        try {
            result = System.getProperty(key);
            if (result != null) {
                propertyMap.put(key, result);
            }
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    private static String getSecureEnvironment(String name) {
        String result;
        try {
            result = System.getenv(name);
            if (result != null) {
                environmentMap.put(name, result);
            }
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    public static String getVMInfo() {
        StringBuilder result = new StringBuilder();
        NumberFormat nform = NumberFormat.getNumberInstance();
        result.append("\u6700\u5927\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u91cf: " + nform.format(Jindolf.RUNTIME.maxMemory()) + " bytes\n");
        result.append("\n");
        result.append("\u8d77\u52d5\u6642\u5f15\u6570:\n");
        for (String arg : Jindolf.getOptionInfo().getInvokeArgList()) {
            result.append("  ").append(arg).append("\n");
        }
        result.append("\n");
        result.append("\u4e3b\u8981\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3:\n");
        Set<String> propKeys = propertyMap.keySet();
        for (String propKey : propKeys) {
            if (propKey.equals("java.class.path")) continue;
            String value = propertyMap.get(propKey);
            result.append("  ");
            result.append(propKey).append("=").append(value).append("\n");
        }
        result.append("\n");
        result.append("\u4e3b\u8981\u74b0\u5883\u5909\u6570:\n");
        Set<String> envKeys = environmentMap.keySet();
        for (String envKey : envKeys) {
            String value = environmentMap.get(envKey);
            result.append("  ");
            result.append(envKey).append("=").append(value).append("\n");
        }
        result.append("\n");
        result.append("\u30af\u30e9\u30b9\u30d1\u30b9:\n");
        for (String path : classpaths) {
            result.append("  ");
            result.append(path).append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    private EnvInfo() {
        throw new Error();
    }

    static {
        environmentMap = new TreeMap<String, String>();
        osName = EnvInfo.getSecureProperty("os.name");
        osVersion = EnvInfo.getSecureProperty("os.version");
        osArch = EnvInfo.getSecureProperty("os.arch");
        javaVendor = EnvInfo.getSecureProperty("java.vendor");
        javaVersion = EnvInfo.getSecureProperty("java.version");
        classpath = EnvInfo.getSecureProperty("java.class.path");
        envLANG = EnvInfo.getSecureEnvironment("LANG");
        envDISPLAY = EnvInfo.getSecureEnvironment("DISPLAY");
        classpaths = classpath != null ? classpath.split(File.pathSeparator) : new String[0];
    }
}

