/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontUtils {
    public static final String FAMILY_DIALOG = "Dialog";
    public static final String FAMILY_MONO = "Monospaced";
    private static final Locale ROOT = new Locale("", "", "");
    private static final String[] INIT_FAMILY_NAMES = new String[]{"Hiragino Kaku Gothic Pro", "Hiragino Kaku Gothic Std", "Osaka", "MS PGothic", "MS Gothic"};
    private static final String JPCHECK_CODE = "9A\u3042\u3091\u30a2\uff71\u30f4\u30f0\u253c\u0416\u03a9\u5ce0\u51dc\u7199";
    private static final Map<TextAttribute, String> TEXTATTR_MONO = Collections.singletonMap(TextAttribute.FAMILY, "Monospaced");

    public static boolean isValidFamilyName(String family) {
        int style = 0;
        int size = 1;
        Font dummyFont = new Font(family, style, size);
        String dummyFamily = FontUtils.getRootFamilyName(dummyFont);
        String dummyLocalFamily = dummyFont.getFamily();
        if (dummyFamily.equals(family)) {
            return true;
        }
        return dummyLocalFamily.equals(family);
    }

    public static Font createDefaultSpeechFont() {
        String defaultFamilyName = FAMILY_DIALOG;
        for (String familyName : INIT_FAMILY_NAMES) {
            if (!FontUtils.isValidFamilyName(familyName)) continue;
            defaultFamilyName = familyName;
            break;
        }
        int style = 0;
        int size = 16;
        Font result = new Font(defaultFamilyName, style, size);
        return result;
    }

    public static SortedSet<String> createFontSet() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : ge.getAllFonts()) {
            if (font.canDisplayUpTo(JPCHECK_CODE) >= 0) continue;
            String familyName = font.getFamily();
            result.add(familyName.intern());
        }
        return Collections.unmodifiableSortedSet(result);
    }

    public static boolean guessBitmapFont(Font font) {
        String familyName = FontUtils.getRootFamilyName(font);
        return font.getSize() < 24 && familyName.startsWith("MS") && (familyName.contains("Gothic") || familyName.contains("Mincho"));
    }

    public static Font deriveMonoFont(Font font) {
        Font monofont = font.deriveFont(TEXTATTR_MONO);
        return monofont;
    }

    public static void forceMonoPitchFont(JComponent comp) {
        JTextComponent textComp;
        Font font = comp.getFont();
        Font monofont = FontUtils.deriveMonoFont(font);
        comp.setFont(monofont);
        if (comp instanceof JTextComponent && !(textComp = (JTextComponent)comp).isEditable()) {
            textComp.setCaretPosition(0);
        }
        comp.revalidate();
    }

    public static String getFontDecodeName(Font font) {
        StringBuilder result = new StringBuilder();
        StringBuilder style = new StringBuilder();
        if (font.isBold()) {
            style.append("BOLD");
        }
        if (font.isItalic()) {
            style.append("ITALIC");
        }
        if (style.length() <= 0) {
            style.append("PLAIN");
        }
        result.append(FontUtils.getRootFamilyName(font));
        result.append('-').append((CharSequence)style);
        result.append('-').append(font.getSize());
        if (result.indexOf(" ") >= 0 || result.indexOf("\u3000") >= 0) {
            result.insert(0, '\"').append('\"');
        }
        return result.toString();
    }

    public static String getRootFamilyName(Font font) {
        return font.getFamily(ROOT);
    }

    private FontUtils() {
        assert (false);
    }
}

