/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InterVMLock {
    private static final Set<InterVMLock> ownedLockSet = Collections.synchronizedSet(new HashSet());
    private final File lockFile;
    private boolean isFileOwner = false;
    private FileOutputStream stream = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addOwnedLock(InterVMLock lock) {
        Set<InterVMLock> set = ownedLockSet;
        synchronized (set) {
            if (!lock.isFileOwner()) {
                return;
            }
            ownedLockSet.add(lock);
            lock.getLockFile().deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeOwnedLock(InterVMLock lock) {
        Set<InterVMLock> set = ownedLockSet;
        synchronized (set) {
            ownedLockSet.remove(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearOwnedLockSet() {
        Set<InterVMLock> set = ownedLockSet;
        synchronized (set) {
            for (InterVMLock lock : ownedLockSet) {
                if (!lock.isFileOwner()) continue;
                lock.release();
                try {
                    lock.getLockFile().delete();
                }
                catch (SecurityException securityException) {}
            }
            ownedLockSet.clear();
        }
    }

    public InterVMLock(File lockFile) throws NullPointerException {
        if (lockFile == null) {
            throw new NullPointerException();
        }
        this.lockFile = lockFile;
    }

    public File getLockFile() {
        return this.lockFile;
    }

    public boolean isExistsFile() {
        return this.lockFile.exists();
    }

    public synchronized boolean isFileOwner() {
        return this.isFileOwner;
    }

    protected synchronized FileOutputStream getOpenedStream() {
        if (this.isFileOwner()) {
            return this.stream;
        }
        return null;
    }

    public synchronized boolean forceRemove() {
        if (this.isFileOwner()) {
            this.release();
        }
        if (!this.isExistsFile()) {
            return true;
        }
        try {
            this.lockFile.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return !this.isExistsFile();
    }

    protected synchronized boolean touchLockFile() {
        boolean result = false;
        try {
            result = this.lockFile.createNewFile();
        }
        catch (IOException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (!result) {
            return false;
        }
        try {
            this.isFileOwner = true;
            this.stream = new FileOutputStream(this.lockFile);
        }
        catch (FileNotFoundException e) {
            assert (false);
            this.isFileOwner = false;
            this.stream = null;
            try {
                this.lockFile.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return false;
        }
        InterVMLock.addOwnedLock(this);
        return true;
    }

    public synchronized boolean tryLock() {
        if (this.isFileOwner()) {
            return true;
        }
        if (this.isExistsFile()) {
            return false;
        }
        return this.touchLockFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        if (!this.isFileOwner()) {
            return;
        }
        try {
            this.stream.close();
        }
        catch (IOException e) {
            this.stream = null;
            try {
                this.lockFile.delete();
            }
            catch (SecurityException securityException) {
            }
            finally {
                InterVMLock.removeOwnedLock(this);
                this.isFileOwner = false;
            }
        }
        finally {
            this.stream = null;
            try {
                this.lockFile.delete();
            }
            catch (SecurityException e) {
            }
            finally {
                InterVMLock.removeOwnedLock(this);
                this.isFileOwner = false;
            }
        }
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(){

            public void run() {
                InterVMLock.clearOwnedLockSet();
            }
        });
    }
}

