/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.text.CharacterIterator;

public class SequenceCharacterIterator
implements CharacterIterator {
    private CharSequence source;
    private final int cursorBegin;
    private final int cursorEnd;
    private final int cursorLength;
    private int cursorPos;

    public SequenceCharacterIterator(CharSequence source, int cursorBegin, int cursorEnd) {
        if (cursorBegin > cursorEnd) {
            throw new IllegalArgumentException();
        }
        if (cursorBegin < 0 || source.length() < cursorEnd) {
            throw new IndexOutOfBoundsException();
        }
        this.source = source;
        this.cursorBegin = cursorBegin;
        this.cursorEnd = cursorEnd;
        this.cursorLength = this.cursorEnd - this.cursorBegin;
        this.cursorPos = this.cursorBegin;
    }

    public SequenceCharacterIterator(CharSequence source) {
        this.source = source;
        this.cursorBegin = 0;
        this.cursorEnd = source.length();
        this.cursorLength = this.cursorEnd - this.cursorBegin;
        this.cursorPos = this.cursorBegin;
    }

    public char first() {
        this.cursorPos = this.cursorBegin;
        return this.current();
    }

    public char last() {
        this.cursorPos = this.cursorEnd - 1;
        return this.current();
    }

    public char current() {
        if (this.cursorLength <= 0 || this.cursorPos < this.cursorBegin) {
            this.cursorPos = this.cursorBegin;
            return '\uffff';
        }
        if (this.cursorPos >= this.cursorEnd) {
            this.cursorPos = this.cursorEnd;
            return '\uffff';
        }
        return this.source.charAt(this.cursorPos);
    }

    public char next() {
        ++this.cursorPos;
        return this.current();
    }

    public char previous() {
        --this.cursorPos;
        return this.current();
    }

    public char setIndex(int newPos) throws IllegalArgumentException {
        if (newPos < this.cursorBegin || this.cursorEnd < newPos) {
            throw new IllegalArgumentException();
        }
        this.cursorPos = newPos;
        return this.current();
    }

    public int getBeginIndex() {
        return this.cursorBegin;
    }

    public int getEndIndex() {
        return this.cursorEnd;
    }

    public int getIndex() {
        return this.cursorPos;
    }

    public Object clone() {
        Object result;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
        SequenceCharacterIterator seq = (SequenceCharacterIterator)result;
        seq.source = ((Object)this.source).toString();
        return seq;
    }
}

