/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.MonospaceLabel;
import jp.sourceforge.jindolf.WebIPCDialog;

public class WebButton
extends JPanel
implements ActionListener {
    private static final String ACTION_SHOWWEB = "SHOWWEB";
    private final JLabel caption = new MonospaceLabel();
    private final JButton button = new JButton("Web");
    private String webUrlText;

    public WebButton() {
        this.button.setIcon(GUIUtils.getWWWIcon());
        this.button.setMargin(new Insets(1, 1, 1, 1));
        this.button.setActionCommand(ACTION_SHOWWEB);
        this.button.addActionListener(this);
        this.button.setToolTipText("Web\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a");
        this.design();
    }

    private void design() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.gridwidth = -1;
        constraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.caption, constraints);
        this.add((Component)this.button, constraints);
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.button.setEnabled(b);
    }

    public void setCaption(CharSequence seq) {
        this.caption.setText(((Object)seq).toString());
    }

    public void setURL(URL url) {
        this.setURLText(url.toString());
    }

    public void setURI(URI uri) {
        this.setURLText(uri.toString());
    }

    public void setURLText(CharSequence urlText) {
        String str = ((Object)urlText).toString();
        try {
            new URL(str);
            this.setEnabled(true);
        }
        catch (MalformedURLException e) {
            this.setEnabled(false);
        }
        this.webUrlText = str;
        this.setCaption(this.webUrlText);
    }

    public void showDialog() {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        WebIPCDialog.showDialog(frame, this.webUrlText);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() != this.button) {
            return;
        }
        String command = event.getActionCommand();
        if (command.equals(ACTION_SHOWWEB)) {
            this.showDialog();
        }
    }
}

