/*
 * mono-pitched font label
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: MonospaceLabel.java 930 2009-11-30 03:35:03Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;

/**
 * 等幅フォントラベル。
 * javax.swing.JLabelの代替品。
 */
@SuppressWarnings("serial")
public class MonospaceLabel extends JLabel{

    /**
     * コンストラクタ。
     */
    public MonospaceLabel(){
        super();
        forceMonoFont();
        return;
    }

    /**
     * コンストラクタ。
     * @param image アイコン
     */
    public MonospaceLabel(Icon image){
        super(image);
        forceMonoFont();
        return;
    }

    /**
     * コンストラクタ。
     * @param image アイコン
     * @param horizontalAlignment SwingConstants で定義されている
     * 定数 LEFT、CENTER、RIGHT、LEADING、または TRAILING のうちの 1 つ
     */
    public MonospaceLabel(Icon image, int horizontalAlignment){
        super(image, horizontalAlignment);
        forceMonoFont();
        return;
    }

    /**
     * コンストラクタ。
     * @param text 文字列
     */
    public MonospaceLabel(String text){
        super(text);
        forceMonoFont();
        return;
    }

    /**
     * コンストラクタ。
     * @param text 文字列
     * @param icon アイコン
     * @param horizontalAlignment SwingConstants で定義されている
     * 定数 LEFT、CENTER、RIGHT、LEADING、または TRAILING のうちの 1 つ
     */
    public MonospaceLabel(String text,
                            Icon icon,
                            int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        forceMonoFont();
        return;
    }

    /**
     * コンストラクタ。
     * @param text 文字列
     * @param horizontalAlignment SwingConstants で定義されている
     * 定数 LEFT、CENTER、RIGHT、LEADING、または TRAILING のうちの 1 つ
     */
    public MonospaceLabel(String text,
                            int horizontalAlignment) {
        super(text, horizontalAlignment);
        forceMonoFont();
        return;
    }

    /**
     * 現時点でのフォントを等幅化する。
     * @return 今までのフォント
     */
    private Font forceMonoFont(){
        Font oldFont = getFont();
        setFont(oldFont);
        return oldFont;
    }

    /**
     * {@inheritDoc}
     * フォント変更をフックして等幅フォント化する。
     * @param font {@inheritDoc}
     */
    @Override
    public void setFont(Font font){
        Font monoFont = FontUtils.deriveMonoFont(font);
        super.setFont(monoFont);
        return;
    }

}
