/*
 * system event in game
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: SysEvent.java 888 2009-11-04 06:23:35Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.parser.DecodedContent;

/**
 * 人狼BBSシステムが生成する各種メッセージ。
 * Topicの具体化。
 */
public class SysEvent implements Topic{
    // TODO 狼の襲撃先表示は Talk か SysEvent どちらにしよう...

    private EventFamily eventFamily;
    private SysEventType sysEventType;
    private DecodedContent content;

    final List<Avatar>   avatarList  = new LinkedList<Avatar>();
    final List<GameRole> roleList    = new LinkedList<GameRole>();
    final List<Integer>  integerList = new LinkedList<Integer>();
    final List<CharSequence>  charseqList =
            new LinkedList<CharSequence>();

    /**
     * コンストラクタ。
     */
    public SysEvent(){
        super();
        return;
    }

    /**
     * イベントファミリを取得する。
     * @return イベントファミリ
     */
    public EventFamily getEventFamily(){
        return this.eventFamily;
    }

    /**
     * イベントファミリを設定する。
     * @param eventFamily イベントファミリ
     * @throws NullPointerException 引数がnull
     */
    public void setEventFamily(EventFamily eventFamily)
            throws NullPointerException{
        this.eventFamily = eventFamily;
        return;
    }

    /**
     * イベント種別を取得する。
     * @return イベント種別
     */
    public SysEventType getSysEventType(){
        return this.sysEventType;
    }

    /**
     * イベント種別を設定する。
     * @param type イベント種別
     * @throws NullPointerException 引数がnull
     */
    public void setSysEventType(SysEventType type)
            throws NullPointerException{
        if(type == null) throw new NullPointerException();
        this.sysEventType = type;
        return;
    }

    /**
     * イベントメッセージを取得する。
     * @return イベントメッセージ
     */
    public DecodedContent getContent(){
        return this.content;
    }

    /**
     * イベントメッセージを設定する。
     * @param content イベントメッセージ
     * @throws NullPointerException 引数がnull
     */
    public void setContent(DecodedContent content)
            throws NullPointerException{
        if(content == null) throw new NullPointerException();
        this.content = content;
        return;
    }

    /**
     * Avatarリストを取得する。
     * @return Avatarリスト
     */
    public List<Avatar> getAvatarList(){
        List<Avatar> result = Collections.unmodifiableList(this.avatarList);
        return result;
    }

    /**
     * Roleリストを取得する。
     * @return Roleリスト
     */
    public List<GameRole> getRoleList(){
        List<GameRole> result = Collections.unmodifiableList(this.roleList);
        return result;
    }

    /**
     * Integerリストを取得する。
     * @return Integerリスト
     */
    public List<Integer> getIntegerList(){
        List<Integer> result = Collections.unmodifiableList(this.integerList);
        return result;
    }

    /**
     * CharSequenceリストを取得する。
     * @return CharSequenceリスト
     */
    public List<CharSequence> getCharSequenceList(){
        List<CharSequence> result =
                Collections.unmodifiableList(this.charseqList);
        return result;
    }

}
