/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.AbstractTextRow;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.FontInfo;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.corelib.TalkType;

public class AnchorDraw
extends AbstractTextRow {
    private static final Color COLOR_ANCHOR = new Color(0xFFFF99);
    private static final int UNDER_MARGIN = 5;
    private final Talk talk;
    private final GlyphDraw caption;
    private final GlyphDraw dialog;
    private final Image faceImage;
    private final Point imageOrigin = new Point();
    private final Point captionOrigin = new Point();
    private final Point dialogOrigin = new Point();

    public AnchorDraw(Talk talk) {
        this(talk, FontInfo.DEFAULT_FONTINFO);
    }

    public AnchorDraw(Talk talk, FontInfo fontInfo) {
        super(fontInfo);
        this.talk = talk;
        Period period = this.talk.getPeriod();
        Village village = period.getVillage();
        Avatar avatar = this.talk.getAvatar();
        BufferedImage image = this.talk.getTalkType() == TalkType.GRAVE ? village.getGraveImage() : village.getAvatarFaceImage(avatar);
        this.faceImage = image;
        this.caption = new GlyphDraw(this.getCaptionString(), this.fontInfo);
        this.dialog = new GlyphDraw(this.talk.getDialog(), this.fontInfo);
        this.caption.setColor(COLOR_ANCHOR);
        this.dialog.setColor(COLOR_ANCHOR);
    }

    private CharSequence getCaptionString() {
        StringBuilder result = new StringBuilder();
        Avatar avatar = this.talk.getAvatar();
        result.append(avatar.getFullName()).append(' ').append(this.talk.getAnchorNotation());
        return result;
    }

    public Rectangle recalcBounds() {
        int captionYpos;
        int imageYpos;
        int newWidth = this.getWidth();
        int imageWidth = this.faceImage.getWidth(null);
        int imageHeight = this.faceImage.getHeight(null);
        this.caption.setWidth(newWidth - imageWidth);
        int captionWidth = this.caption.getWidth();
        int captionHeight = this.caption.getHeight();
        this.dialog.setWidth(newWidth);
        int dialogWidth = this.dialog.getWidth();
        int dialogHeight = this.dialog.getHeight();
        int headerHeight = Math.max(imageHeight, captionHeight);
        int totalWidth = Math.max(imageWidth + captionWidth, dialogWidth);
        int totalHeight = headerHeight;
        totalHeight += dialogHeight;
        if (imageHeight > captionHeight) {
            imageYpos = 0;
            captionYpos = (imageHeight - captionHeight) / 2;
        } else {
            imageYpos = (captionHeight - imageHeight) / 2;
            captionYpos = 0;
        }
        this.imageOrigin.setLocation(0, imageYpos);
        this.captionOrigin.setLocation(imageWidth, captionYpos);
        this.dialogOrigin.setLocation(0, headerHeight);
        this.bounds.width = totalWidth;
        this.bounds.height = totalHeight + 5;
        return this.bounds;
    }

    public void setFontInfo(FontInfo fontInfo) {
        super.setFontInfo(fontInfo);
        this.caption.setFontInfo(this.fontInfo);
        this.dialog.setFontInfo(this.fontInfo);
        this.recalcBounds();
    }

    public void drag(Point from, Point to) {
        this.caption.drag(from, to);
        this.dialog.drag(from, to);
    }

    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.caption.appendSelected(appendable);
        this.dialog.appendSelected(appendable);
        return appendable;
    }

    public void clearSelect() {
        this.caption.clearSelect();
        this.dialog.clearSelect();
    }

    public int setRegex(Pattern searchRegex) {
        int total = 0;
        return total += this.dialog.setRegex(searchRegex);
    }

    public void paint(Graphics2D g) {
        int xPos = this.bounds.x;
        int yPos = this.bounds.y;
        g.drawImage(this.faceImage, xPos + this.imageOrigin.x, yPos + this.imageOrigin.y, null);
        this.caption.setPos(xPos + this.captionOrigin.x, yPos + this.captionOrigin.y);
        this.caption.paint(g);
        this.dialog.setPos(xPos + this.dialogOrigin.x, yPos + this.dialogOrigin.y);
        this.dialog.paint(g);
    }
}

