/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jp.sourceforge.jindolf.DialogPref;

public class DialogPrefPanel
extends JPanel
implements ActionListener {
    private final JCheckBox useBodyImage = new JCheckBox("\u30c7\u30ab\u30ad\u30e3\u30e9\u30e2\u30fc\u30c9");
    private final JCheckBox useMonoImage = new JCheckBox("\u5893\u77f3\u3092\u907a\u5f71\u306b\u7f6e\u304d\u63db\u3048\u308b");
    private final JButton resetDefault = new JButton("\u51fa\u8377\u6642\u306b\u623b\u3059");

    public DialogPrefPanel() {
        this.resetDefault.addActionListener(this);
        this.design(this);
    }

    private void design(Container content) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 18;
        content.add((Component)this.useBodyImage, constraints);
        content.add((Component)this.useMonoImage, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 14;
        content.add((Component)this.resetDefault, constraints);
    }

    public boolean useBodyImage() {
        return this.useBodyImage.isSelected();
    }

    public boolean useMonoImage() {
        return this.useMonoImage.isSelected();
    }

    public void setBodyImageSetting(boolean setting) {
        this.useBodyImage.setSelected(setting);
    }

    public void setMonoImageSetting(boolean setting) {
        this.useMonoImage.setSelected(setting);
    }

    public void setDialogPref(DialogPref pref) {
        this.setBodyImageSetting(pref.useBodyImage());
        this.setMonoImageSetting(pref.useMonoImage());
    }

    public DialogPref getDialogPref() {
        DialogPref result = new DialogPref();
        result.setBodyImageSetting(this.useBodyImage());
        result.setMonoImageSetting(this.useMonoImage());
        return result;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source != this.resetDefault) {
            return;
        }
        this.useBodyImage.setSelected(false);
        this.useMonoImage.setSelected(false);
    }
}

