/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import jp.sourceforge.jindolf.AbstractTextRow;
import jp.sourceforge.jindolf.FontInfo;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.parser.DecodedContent;

public class SysEventDraw
extends AbstractTextRow {
    public static final Color COLOR_ANNOUNCE = new Color(0xFFFFFF);
    public static final Color COLOR_ORDER = new Color(0xF04040);
    public static final Color COLOR_EXTRA = new Color(0x808080);
    private static final int INSET = 10;
    private static final int UNDER_MARGIN = 15;
    private final SysEvent sysEvent;
    private final GlyphDraw sysMessage;

    public SysEventDraw(SysEvent sysEvent) {
        this(sysEvent, FontInfo.DEFAULT_FONTINFO);
    }

    public SysEventDraw(SysEvent sysEvent, FontInfo fontInfo) {
        super(fontInfo);
        this.sysEvent = sysEvent;
        DecodedContent content = this.sysEvent.getContent();
        CharSequence rawContent = content.getRawContent();
        this.sysMessage = new GlyphDraw(rawContent, this.fontInfo);
        this.sysMessage.setColor(this.getEventColor());
    }

    public SysEvent getSysEvent() {
        return this.sysEvent;
    }

    private Color getEventColor() {
        Color result;
        switch (this.sysEvent.getEventFamily()) {
            case ANNOUNCE: {
                result = COLOR_ANNOUNCE;
                break;
            }
            case ORDER: {
                result = COLOR_ORDER;
                break;
            }
            case EXTRA: {
                result = COLOR_EXTRA;
                break;
            }
            default: {
                assert (false);
                result = null;
            }
        }
        return result;
    }

    public Rectangle recalcBounds() {
        int newWidth = this.getWidth();
        Rectangle child = this.sysMessage.setWidth(newWidth - 10 - 10);
        this.bounds.width = newWidth;
        this.bounds.height = child.height + 10 + 10 + 15;
        return this.bounds;
    }

    public void setFontInfo(FontInfo fontInfo) {
        super.setFontInfo(fontInfo);
        this.sysMessage.setFontInfo(this.fontInfo);
        this.recalcBounds();
    }

    public void drag(Point from, Point to) {
        this.sysMessage.drag(from, to);
    }

    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.sysMessage.appendSelected(appendable);
        return appendable;
    }

    public void clearSelect() {
        this.sysMessage.clearSelect();
    }

    public void setPos(int xPos, int yPos) {
        super.setPos(xPos, yPos);
        this.sysMessage.setPos(this.bounds.x + 10, this.bounds.y + 10);
    }

    public void paint(Graphics2D g) {
        g.setColor(this.getEventColor());
        g.drawRect(this.bounds.x, this.bounds.y, this.bounds.width - 1, this.bounds.height - 15);
        this.sysMessage.paint(g);
    }
}

