/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.corelib.TalkType;

public class Talk
implements Topic {
    private final Period homePeriod;
    private final TalkType talkType;
    private final Avatar avatar;
    private final String messageID;
    private final int hour;
    private final int minute;
    private final CharSequence dialog;
    private final int charNum;
    private int count = -1;

    public static String encodeColorName(TalkType type) {
        String result;
        switch (type) {
            case PUBLIC: {
                result = "\u767d";
                break;
            }
            case PRIVATE: {
                result = "\u7070";
                break;
            }
            case WOLFONLY: {
                result = "\u8d64";
                break;
            }
            case GRAVE: {
                result = "\u9752";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    public Talk(Period homePeriod, TalkType talkType, Avatar avatar, String messageID, int hour, int minute, CharSequence dialog) {
        if (homePeriod == null || talkType == null || avatar == null || messageID == null || dialog == null) {
            throw new NullPointerException();
        }
        if (hour < 0 || 23 < hour) {
            throw new IllegalArgumentException();
        }
        if (minute < 0 || 59 < minute) {
            throw new IllegalArgumentException();
        }
        this.homePeriod = homePeriod;
        this.talkType = talkType;
        this.avatar = avatar;
        this.messageID = messageID;
        this.hour = hour;
        this.minute = minute;
        this.dialog = dialog;
        this.charNum = this.dialog.length();
    }

    public Period getPeriod() {
        return this.homePeriod;
    }

    public TalkType getTalkType() {
        return this.talkType;
    }

    public int getTalkCount() {
        return this.count;
    }

    public int getTotalChars() {
        return this.charNum;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public long getTimeFromID() {
        String epoch = this.messageID.replace("mes", "");
        long result = Long.parseLong(epoch) * 1000L;
        return result;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public CharSequence getDialog() {
        return this.dialog;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getAnchorNotation() {
        int day = this.homePeriod.getDay();
        String hstr = "0" + this.hour;
        hstr = hstr.substring(hstr.length() - 2);
        String mstr = "0" + this.minute;
        mstr = mstr.substring(mstr.length() - 2);
        return day + "d" + hstr + ":" + mstr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.avatar.getFullName());
        if (this.talkType == TalkType.PUBLIC) {
            result.append(" says ");
        } else if (this.talkType == TalkType.PRIVATE) {
            result.append(" think ");
        } else if (this.talkType == TalkType.WOLFONLY) {
            result.append(" howl ");
        } else if (this.talkType == TalkType.GRAVE) {
            result.append(" groan ");
        }
        result.append(this.dialog);
        return result.toString();
    }
}

