/*
 * dialog preferences
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: DialogPref.java 963 2009-12-20 12:55:11Z olyutorskii $
 */

package jp.sourceforge.jindolf;

/**
 * 発言表示設定。
 */
public class DialogPref{

    private boolean useBodyImage = false;
    private boolean useMonoImage = false;

    /**
     * コンストラクタ。
     */
    public DialogPref(){
        super();
        return;
    }

    /**
     * デカキャラモードを使うか否か状態を返す。
     * @return デカキャラモードを使うならtrue
     */
    public boolean useBodyImage(){
        return this.useBodyImage;
    }

    /**
     * 遺影モードを使うか否か状態を返す。
     * @return 遺影モードを使うならtrue
     */
    public boolean useMonoImage(){
        return this.useMonoImage;
    }

    /**
     * デカキャラモードの設定を行う。
     * @param setting 有効にするならtrue
     */
    public void setBodyImageSetting(boolean setting){
        this.useBodyImage = setting;
        return;
    }

    /**
     * 遺影モードの設定を行う。
     * @param setting 有効にするならtrue
     */
    public void setMonoImageSetting(boolean setting){
        this.useMonoImage = setting;
        return;
    }

    /**
     * {@inheritDoc}
     * @param obj {@inheritDoc}
     * @return {@inheritDoc}
     */
    @Override
    public boolean equals(Object obj){
        if(obj instanceof DialogPref) return false;
        DialogPref target = (DialogPref) obj;

        if(this.useBodyImage != target.useBodyImage) return false;
        if(this.useMonoImage != target.useMonoImage) return false;

        return true;
    }

    /**
     * {@inheritDoc}
     * @return {@inheritDoc}
     */
    @Override
    public int hashCode(){
        int hash;
        hash  = Boolean.valueOf(this.useBodyImage).hashCode();
        hash ^= Boolean.valueOf(this.useMonoImage).hashCode();
        return hash;
    }

}
