/*
 * dialog preference panel
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: DialogPrefPanel.java 963 2009-12-20 12:55:11Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

/**
 * 発言表示の各種設定パネル。
 */
@SuppressWarnings("serial")
public class DialogPrefPanel extends JPanel implements ActionListener{

    private final JCheckBox useBodyImage = new JCheckBox("デカキャラモード");
    private final JCheckBox useMonoImage =
            new JCheckBox("墓石を遺影に置き換える");
    private final JButton resetDefault = new JButton("出荷時に戻す");

    /**
     * コンストラクタ。
     */
    public DialogPrefPanel(){
        this.resetDefault.addActionListener(this);
        design(this);
        return;
    }

    /**
     * レイアウトを行う。
     * @param content コンテナ
     */
    private void design(Container content){
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();

        content.setLayout(layout);

        constraints.insets = new Insets(2, 2, 2, 2);

        constraints.weightx = 0.0;
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.fill = GridBagConstraints.NONE;
        constraints.anchor = GridBagConstraints.NORTHWEST;

        content.add(this.useBodyImage, constraints);
        content.add(this.useMonoImage, constraints);

        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = GridBagConstraints.NONE;
        constraints.anchor = GridBagConstraints.SOUTHEAST;
        content.add(this.resetDefault, constraints);

        return;
    }

    /**
     * デカキャラモードを使うか否か状態を返す。
     * @return デカキャラモードを使うならtrue
     */
    public boolean useBodyImage(){
        return this.useBodyImage.isSelected();
    }

    /**
     * 遺影モードを使うか否か状態を返す。
     * @return 遺影モードを使うならtrue
     */
    public boolean useMonoImage(){
        return this.useMonoImage.isSelected();
    }

    /**
     * デカキャラモードの設定を行う。
     * @param setting 有効にするならtrue
     */
    public void setBodyImageSetting(boolean setting){
        this.useBodyImage.setSelected(setting);
        return;
    }

    /**
     * 遺影モードの設定を行う。
     * @param setting 有効にするならtrue
     */
    public void setMonoImageSetting(boolean setting){
        this.useMonoImage.setSelected(setting);
        return;
    }

    /**
     * 発言表示設定を設定する。
     * @param pref 表示設定
     */
    public void setDialogPref(DialogPref pref){
        setBodyImageSetting(pref.useBodyImage());
        setMonoImageSetting(pref.useMonoImage());
        return;
    }

    /**
     * 発言表示設定を返す。
     * @return 表示設定
     */
    public DialogPref getDialogPref(){
        DialogPref result = new DialogPref();
        result.setBodyImageSetting(useBodyImage());
        result.setMonoImageSetting(useMonoImage());
        return result;
    }

    /**
     * デフォルトボタン押下処理。
     * @param event ボタン押下イベント
     */
    public void actionPerformed(ActionEvent event){
        Object source = event.getSource();
        if(source != this.resetDefault) return;
        this.useBodyImage.setSelected(false);
        this.useMonoImage.setSelected(false);
        return;
    }

}
