/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.util.regex.Pattern;
import jp.sourceforge.jindolf.corelib.TalkType;
import jp.sourceforge.jindolf.parser.AbstractParser;
import jp.sourceforge.jindolf.parser.ChainedParser;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.SeqRange;
import jp.sourceforge.jindolf.parser.TalkHandler;

public class TalkParser
extends AbstractParser {
    private TalkHandler talkHandler;
    private final SeqRange rangepool_1 = new SeqRange();
    private static final Pattern AVATARNAME_PATTERN = TalkParser.compile("([^<]*)");
    private static final Pattern TALKTIME_PATTERN = TalkParser.compile("</a>[ \\t\\n\\r]*<span class=\"time\">(?:(\u5348\u524d )|(\u5348\u5f8c ))?([0-9][0-9]?)(?:\u6642 |\\:)([0-9][0-9]?)\u5206? </span>[ \\t\\n\\r]*<table [^>]*>[ \\t\\n\\r]*(?:<tbody>)?[ \\t\\n\\r]*<tr>");
    private static final Pattern IMGSRC_PATTERN = TalkParser.compile("<td [^>]*><img src=\"([^\"]*)\"></td>[ \\t\\n\\r]*<td [^>]*><img [^>]*></td>");
    private static final Pattern TALKDIC_PATTERN = TalkParser.compile("<td>[ \\t\\n\\r]*<div(?: [^>]*)?>[ \\t\\n\\r]*<div class=\"mes_(?:(say)|(think)|(whisper)|(groan))_body1\">");
    private static final Pattern TEXT_PATTERN = TalkParser.compile("([^<>]+)|(<br />)");
    private static final Pattern TAIL_PATTERN = TalkParser.compile("</div>[ \\t\\n\\r]*</div>[ \\t\\n\\r]*</td>[ \\t\\n\\r]*</tr>[ \\t\\n\\r]*(?:</tbody>)?[ \\t\\n\\r]*</table>");

    public TalkParser(ChainedParser parent) {
        super(parent);
    }

    public void setTalkHandler(TalkHandler talkHandler) {
        this.talkHandler = talkHandler;
    }

    public void parseTalk(SeqRange nameRange) throws HtmlParseException {
        this.talkHandler.startTalk();
        this.talkHandler.talkId(this.getContent(), nameRange);
        this.parseName();
        this.parseTime();
        this.parseIcon();
        this.parseType();
        this.parseText();
        this.parseTail();
        this.talkHandler.endTalk();
    }

    private void parseName() throws HtmlParseException {
        this.setContextErrorMessage("lost dialog avatar-name");
        SeqRange avatarRange = this.rangepool_1;
        this.lookingAtAffirm(AVATARNAME_PATTERN);
        avatarRange.setLastMatchedGroupRange(this.getMatcher(), 1);
        this.shrinkRegion();
        this.talkHandler.talkAvatar(this.getContent(), avatarRange);
    }

    private void parseTime() throws HtmlParseException {
        this.setContextErrorMessage("lost dialog time");
        this.lookingAtAffirm(TALKTIME_PATTERN);
        int hour = this.parseGroupedInt(3);
        int minute = this.parseGroupedInt(4);
        if (this.isGroupMatched(2)) {
            hour = (hour + 12) % 24;
        }
        this.shrinkRegion();
        this.sweepSpace();
        this.talkHandler.talkTime(hour, minute);
    }

    private void parseIcon() throws HtmlParseException {
        this.setContextErrorMessage("lost icon url");
        SeqRange urlRange = this.rangepool_1;
        this.lookingAtAffirm(IMGSRC_PATTERN);
        urlRange.setLastMatchedGroupRange(this.getMatcher(), 1);
        this.shrinkRegion();
        this.sweepSpace();
        this.talkHandler.talkIconUrl(this.getContent(), urlRange);
    }

    private void parseType() throws HtmlParseException {
        TalkType type;
        this.setContextErrorMessage("lost dialog type");
        this.lookingAtAffirm(TALKDIC_PATTERN);
        if (this.isGroupMatched(1)) {
            type = TalkType.PUBLIC;
        } else if (this.isGroupMatched(2)) {
            type = TalkType.PRIVATE;
        } else if (this.isGroupMatched(3)) {
            type = TalkType.WOLFONLY;
        } else if (this.isGroupMatched(4)) {
            type = TalkType.GRAVE;
        } else {
            assert (false);
            throw this.buildParseException();
        }
        this.shrinkRegion();
        this.talkHandler.talkType(type);
    }

    private void parseText() throws HtmlParseException {
        this.setContextErrorMessage("lost dialog text");
        SeqRange textRange = this.rangepool_1;
        while (this.lookingAtProbe(TEXT_PATTERN)) {
            if (this.isGroupMatched(1)) {
                textRange.setLastMatchedGroupRange(this.getMatcher(), 1);
                this.talkHandler.talkText(this.getContent(), textRange);
            } else if (this.isGroupMatched(2)) {
                this.talkHandler.talkBreak();
            } else {
                assert (false);
                throw this.buildParseException();
            }
            this.shrinkRegion();
        }
    }

    private void parseTail() throws HtmlParseException {
        this.setContextErrorMessage("lost dialog termination");
        this.lookingAtAffirm(TAIL_PATTERN);
        this.shrinkRegion();
        this.sweepSpace();
    }
}

