/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.ActionManager;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.CmdOption;
import jp.sourceforge.jindolf.ConfigFile;
import jp.sourceforge.jindolf.Controller;
import jp.sourceforge.jindolf.Discussion;
import jp.sourceforge.jindolf.EnvInfo;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.LogWrapper;
import jp.sourceforge.jindolf.OptionInfo;
import jp.sourceforge.jindolf.PileHandler;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.TopView;

public final class Jindolf {
    public static final String MINIMUM_JREVER = "1.5";
    public static final Class<?> SELF_KLASS;
    public static final Package SELF_PACKAGE;
    public static final Package JRE_PACKAGE;
    public static final Runtime RUNTIME;
    public static final SecurityManager SEC_MANAGER;
    public static final ClassLoader LOADER;
    public static final long NANOCT_LOADED;
    public static final long EPOCHMS_LOADED;
    private static final String RES_VERDEF = "resources/version.properties";
    public static final String TITLE;
    public static final String VERSION;
    public static final String AUTHOR;
    public static final String COPYRIGHT;
    public static final String LICENSE;
    public static final String CONTACT;
    public static final String DEBUT;
    public static final String COMMENT;
    public static final String ID;
    private static final LogWrapper COMMON_LOGGER;
    private static final AtomicBoolean INVOKE_FLAG;
    private static final String RES_LOGOICON = "resources/image/logo.png";
    private static OptionInfo option;
    private static AppSetting setting;

    public static OptionInfo getOptionInfo() {
        return option;
    }

    public static AppSetting getAppSetting() {
        return setting;
    }

    private static void errorDialog(String title, String message) {
        System.err.println(message);
        System.err.flush();
        if (!JRE_PACKAGE.isCompatibleWith("1.2")) {
            return;
        }
        if (JRE_PACKAGE.isCompatibleWith("1.4") && GraphicsEnvironment.isHeadless()) {
            return;
        }
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadVersionDefinition(Class klass) {
        Properties result = new Properties();
        InputStream istream = klass.getResourceAsStream(RES_VERDEF);
        try {
            result.load(istream);
        }
        catch (IOException e) {
            Properties properties = result;
            return properties;
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException e) {
                return result;
            }
        }
        return result;
    }

    public static String getPackageInfo(Properties prop, String prefix, String defValue) {
        return Jindolf.getPackageInfo(prop, SELF_PACKAGE, prefix, defValue);
    }

    public static String getPackageInfo(Properties prop, Package pkg, String prefix, String defValue) {
        String propName = prefix + pkg.getName();
        String result = prop.getProperty(propName, defValue);
        return result;
    }

    private static void checkGUIEnvironment() {
        if (GraphicsEnvironment.isHeadless()) {
            String dispEnv;
            System.err.println(TITLE + " \u306fGUI\u74b0\u5883\u3068\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
            try {
                dispEnv = System.getenv("DISPLAY");
            }
            catch (SecurityException e) {
                dispEnv = null;
            }
            if (dispEnv != null) {
                System.err.println("\u74b0\u5883\u5909\u6570 DISPLAY : " + dispEnv);
            }
            RUNTIME.exit(1);
        }
    }

    private static void checkCompileError() {
        String errmsg = "\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u6b63\u3057\u304f\u30b3\u30f3\u30d1\u30a4\u30eb\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3082\u3002\n\u3042\u306a\u305f\u306f\u4eca\u3001\u30aa\u30ea\u30b8\u30ca\u30eb\u958b\u767a\u5143\u306e\u610f\u56f3\u3057\u306a\u3044\u6587\u5b57\u30b3\u30fc\u30c9\u74b0\u5883\u3067\u30b3\u30f3\u30d1\u30a4\u30eb\u3055\u308c\u305f\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u8d77\u52d5\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u308b\u3088\u3002\n\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u306e\u5165\u624b\u306b\u969b\u3057\u3066\u3069\u306e\u3088\u3046\u306a\u6587\u5b57\u30b3\u30fc\u30c9\u5909\u63db\u304c\u884c\u308f\u308c\u305f\u304b\u8a8d\u8b58\u3057\u3066\u3044\u308b\u304b\u306a\uff1f\n\u30b3\u30f3\u30d1\u30a4\u30eb\u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u6b63\u3057\u3044\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u305f\u304b\u306a\uff1f";
    }

    private static void checkPackageDefinition() {
        String implTitle = SELF_PACKAGE.getImplementationTitle();
        String implVersion = SELF_PACKAGE.getImplementationVersion();
        String implVendor = SELF_PACKAGE.getImplementationVendor();
        String errmsg = null;
        if (implTitle != null && !implTitle.equals(TITLE)) {
            errmsg = "\u30d1\u30c3\u30b1\u30fc\u30b8\u5b9a\u7fa9\u3068\u30bf\u30a4\u30c8\u30eb\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002[" + implTitle + "]\u2260[" + TITLE + "]";
        } else if (implVersion != null && !implVersion.equals(VERSION)) {
            errmsg = "\u30d1\u30c3\u30b1\u30fc\u30b8\u5b9a\u7fa9\u3068\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002[" + implVersion + "]\u2260[" + VERSION + "]";
        } else if (implVendor != null && !implVendor.equals(AUTHOR)) {
            errmsg = "\u30d1\u30c3\u30b1\u30fc\u30b8\u5b9a\u7fa9\u3068\u30d9\u30f3\u30c0\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002[" + implVendor + "]\u2260[" + AUTHOR + "]";
        }
        if (errmsg != null) {
            JOptionPane.showMessageDialog(null, errmsg, "\u30d3\u30eb\u30c9\u30a8\u30e9\u30fc", 0);
            RUNTIME.exit(1);
        }
    }

    private static void showHelpMessage() {
        System.out.flush();
        System.err.flush();
        CharSequence helpText = CmdOption.getHelpText();
        System.out.print(helpText);
        System.out.flush();
        System.err.flush();
    }

    private static Window createSplashWindow() {
        JWindow splashWindow = new JWindow();
        URL url = Jindolf.getResource(RES_LOGOICON);
        ImageIcon logo = new ImageIcon(url);
        JLabel splashLabel = new JLabel(logo);
        splashWindow.add(splashLabel);
        splashWindow.pack();
        splashWindow.setLocationRelativeTo(null);
        return splashWindow;
    }

    private static void initLogging(boolean useConsoleLog) {
        boolean hasPermission = Jindolf.hasLoggingPermission();
        if (!hasPermission) {
            System.out.println("\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u8a2d\u5b9a\u306b\u3088\u308a\u3001\u30ed\u30b0\u8a2d\u5b9a\u3092\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        Logger jre14Logger = COMMON_LOGGER.getJre14Logger();
        if (hasPermission) {
            jre14Logger.setUseParentHandlers(false);
            PileHandler pileHandler = new PileHandler();
            jre14Logger.addHandler(pileHandler);
        }
        if (hasPermission && useConsoleLog) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            jre14Logger.addHandler(consoleHandler);
        }
    }

    public static boolean hasLoggingPermission() {
        if (SEC_MANAGER == null) {
            return true;
        }
        LoggingPermission logPermission = new LoggingPermission("control", null);
        try {
            SEC_MANAGER.checkPermission(logPermission);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    private static void dumpBootInfo() {
        DateFormat dform = DateFormat.getDateTimeInstance();
        NumberFormat nform = NumberFormat.getNumberInstance();
        Jindolf.logger().info(ID + " \u306f " + dform.format(new Date(EPOCHMS_LOADED)) + " \u306bVM\u4e0a\u306e\u30af\u30e9\u30b9 " + SELF_KLASS.getName() + " \u3068\u3057\u3066\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002 ");
        Jindolf.logger().info("Initial Nano-Count : " + nform.format(NANOCT_LOADED));
        Jindolf.logger().info("Max-heap : " + nform.format(RUNTIME.maxMemory()) + " Byte" + "   Total-heap : " + nform.format(RUNTIME.totalMemory()) + " Byte");
        Jindolf.logger().info("\n" + EnvInfo.getVMInfo());
        if (Jindolf.getAppSetting().useConfigPath()) {
            Jindolf.logger().info("\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b[ " + Jindolf.getAppSetting().getConfigPath().getPath() + " ]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
        } else {
            Jindolf.logger().info("\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u4f7f\u3044\u307e\u305b\u3093\u3002");
        }
        if (JRE_PACKAGE.isCompatibleWith("1.6") && option.hasOption(CmdOption.OPT_NOSPLASH)) {
            Jindolf.logger().warn("JRE1.6\u4ee5\u964d\u3067\u306f\u3001Jindolf\u306e-nosplash\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u7121\u52b9\u3067\u3059\u3002Java\u5b9f\u884c\u7cfb\u306e\u65b9\u3067\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u753b\u9762\u306e\u975e\u8868\u793a\u3092\u6307\u793a\u3057\u3066\u304f\u3060\u3055\u3044(\u304a\u305d\u3089\u304f\u7a7a\u306e-splash:\u30aa\u30d7\u30b7\u30e7\u30f3)");
        }
        if (LOADER == null) {
            Jindolf.logger().warn("\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u8a2d\u5b9a\u306b\u3088\u308a\u3001\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
    }

    private static void preInitClass() throws LinkageError, ExceptionInInitializerError {
        Object[] classes;
        for (Object obj : classes = new Object[]{"java.lang.Object", TabBrowser.class, Discussion.class, GlyphDraw.class, HttpURLConnection.class, SimpleDateFormat.class, Void.class}) {
            String className;
            if (obj instanceof Class) {
                className = ((Class)obj).getName();
            } else {
                if (!(obj instanceof String)) continue;
                className = obj.toString();
            }
            try {
                if (LOADER != null) {
                    Class.forName(className, true, LOADER);
                    continue;
                }
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Jindolf.logger().warn("\u30af\u30e9\u30b9\u306e\u660e\u793a\u7684\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
    }

    private static void startGUI() {
        LandsModel model = new LandsModel();
        model.loadLandList();
        JFrame topFrame = Jindolf.buildMVC(model);
        GUIUtils.modifyWindowAttributes(topFrame, true, false, true);
        topFrame.pack();
        Dimension initGeometry = new Dimension(setting.initialFrameWidth(), setting.initialFrameHeight());
        topFrame.setSize(initGeometry);
        if (setting.initialFrameXpos() <= Integer.MIN_VALUE || setting.initialFrameYpos() <= Integer.MIN_VALUE) {
            topFrame.setLocationByPlatform(true);
        } else {
            topFrame.setLocation(setting.initialFrameXpos(), setting.initialFrameYpos());
        }
        topFrame.setVisible(true);
    }

    private static JFrame buildMVC(LandsModel model) {
        ActionManager actionManager = new ActionManager();
        TopView topView = new TopView();
        Controller controller = new Controller(actionManager, topView, model);
        JFrame topFrame = controller.createTopFrame();
        return topFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence loadResourceText(String resourceName) throws IOException {
        InputStream is = Jindolf.getResourceAsStream(resourceName);
        is = new BufferedInputStream(is);
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        LineNumberReader lineReader = new LineNumberReader(reader);
        StringBuilder result = new StringBuilder();
        try {
            String line;
            while ((line = lineReader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                result.append(line).append('\n');
            }
        }
        finally {
            lineReader.close();
        }
        return result;
    }

    public static InputStream getResourceAsStream(String name) {
        return SELF_KLASS.getResourceAsStream(name);
    }

    public static URL getResource(String name) {
        return SELF_KLASS.getResource(name);
    }

    public static LogWrapper logger() {
        return COMMON_LOGGER;
    }

    public static void exit(int exitCode) throws SecurityException {
        Jindolf.logger().info("\u7d42\u4e86\u30b3\u30fc\u30c9[" + exitCode + "]\u3067VM\u3054\u3068\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
        RUNTIME.runFinalization();
        System.out.flush();
        System.err.flush();
        try {
            RUNTIME.exit(exitCode);
        }
        catch (SecurityException e) {
            Jindolf.logger().warn("\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u8a2d\u5b9a\u306b\u3088\u308a\u3001VM\u3092\u7d42\u4e86\u3055\u305b\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean hasInvoked;
        boolean bl = hasInvoked = !INVOKE_FLAG.compareAndSet(false, true);
        if (hasInvoked) {
            String errmsg = "\u4e8c\u5ea6\u76ee\u4ee5\u964d\u306e\u8d77\u52d5\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002";
            Jindolf.errorDialog("\u591a\u91cd\u8d77\u52d5", errmsg);
            return;
        }
        Jindolf.checkGUIEnvironment();
        Jindolf.checkCompileError();
        Jindolf.checkPackageDefinition();
        try {
            option = OptionInfo.parseOptions(args);
        }
        catch (IllegalArgumentException e) {
            String message = e.getLocalizedMessage();
            System.err.println(message);
            System.err.println("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u4e00\u89a7\u306f\u3001\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u300c" + CmdOption.OPT_HELP.toHyphened() + "\u300d\u3092\u6307\u5b9a\u3059\u308b\u3068\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002");
            RUNTIME.exit(1);
            assert (false);
            return;
        }
        if (option.hasOption(CmdOption.OPT_HELP)) {
            Jindolf.showHelpMessage();
            RUNTIME.exit(0);
            return;
        }
        if (option.hasOption(CmdOption.OPT_VERSION)) {
            System.out.println(ID);
            RUNTIME.exit(0);
            return;
        }
        if (option.hasOption(CmdOption.OPT_BOLDMETAL)) {
            UIManager.put("swing.boldMetal", Boolean.TRUE);
        } else {
            UIManager.put("swing.boldMetal", Boolean.FALSE);
        }
        Window splashWindow = null;
        if (!JRE_PACKAGE.isCompatibleWith("1.6") && !option.hasOption(CmdOption.OPT_NOSPLASH)) {
            splashWindow = Jindolf.createSplashWindow();
            splashWindow.setVisible(true);
            Thread.yield();
        }
        setting = new AppSetting();
        setting.applyOptionInfo(option);
        if (option.hasOption(CmdOption.OPT_VMINFO)) {
            System.out.println(EnvInfo.getVMInfo());
        }
        Jindolf.initLogging(option.hasOption(CmdOption.OPT_CONSOLELOG));
        Jindolf.dumpBootInfo();
        ConfigFile.setupConfigDirectory();
        ConfigFile.setupLockFile();
        setting.loadConfig();
        RUNTIME.addShutdownHook(new Thread(){

            public void run() {
                Jindolf.logger().info("\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u51e6\u7406\u306b\u5165\u308a\u307e\u3059\u2026");
                System.out.flush();
                System.err.flush();
                RUNTIME.gc();
                Thread.yield();
                RUNTIME.runFinalization();
                Thread.yield();
            }
        });
        Jindolf.preInitClass();
        GUIUtils.replaceEventQueue();
        boolean hasError = false;
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    Jindolf.startGUI();
                }
            });
        }
        catch (Throwable e) {
            Jindolf.logger().fatal("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            e.printStackTrace(System.err);
            hasError = true;
        }
        finally {
            if (splashWindow != null) {
                splashWindow.setVisible(false);
                splashWindow.dispose();
                splashWindow = null;
            }
        }
        if (hasError) {
            Jindolf.exit(1);
        }
    }

    private Jindolf() {
        assert (this.getClass() == SELF_KLASS);
    }

    static {
        ClassLoader thisLoader;
        SELF_KLASS = Jindolf.class;
        SELF_PACKAGE = SELF_KLASS.getPackage();
        JRE_PACKAGE = Object.class.getPackage();
        RUNTIME = Runtime.getRuntime();
        SEC_MANAGER = System.getSecurityManager();
        try {
            thisLoader = SELF_KLASS.getClassLoader();
        }
        catch (SecurityException e) {
            thisLoader = null;
        }
        LOADER = thisLoader;
        if (!JRE_PACKAGE.isCompatibleWith(MINIMUM_JREVER)) {
            String jreInstalled;
            try {
                jreInstalled = System.getProperty("java.home");
            }
            catch (SecurityException e) {
                jreInstalled = "\u203b\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u4f4d\u7f6e\u4e0d\u660e";
            }
            String errmsg = "\u4eca\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0 " + SELF_KLASS.getName() + " \u306f\n" + "[ " + jreInstalled + " ]\n\u306b\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u305f" + " JRE" + JRE_PACKAGE.getSpecificationVersion() + " \u306e\u5b9f\u884c\u74b0\u5883\u3067\u5b9f\u884c\u3055\u308c\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u3002\n" + "\u3057\u304b\u3057\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u5b9f\u884c\u306b\u306f" + " JRE" + MINIMUM_JREVER + " \u4ee5\u964d\u306e\u5b9f\u884c\u74b0\u5883\u304c\u5fc5\u8981\u3067\u3059\u3002\n" + "\u304a\u305d\u3089\u304f http://www.java.com/ \u306a\u3069\u304b\u3089\u306e" + "\u5165\u624b\u304c\u53ef\u80fd\u3067\u3057\u3087\u3046\u3002";
            Jindolf.errorDialog("\u5b9f\u884c\u7cfb\u306e\u4e0d\u5099", errmsg);
            RUNTIME.exit(1);
        }
        NANOCT_LOADED = System.nanoTime();
        EPOCHMS_LOADED = System.currentTimeMillis();
        Properties verProp = Jindolf.loadVersionDefinition(SELF_KLASS);
        TITLE = Jindolf.getPackageInfo(verProp, "pkg-title.", "Unknown");
        VERSION = Jindolf.getPackageInfo(verProp, "pkg-version.", "0");
        AUTHOR = Jindolf.getPackageInfo(verProp, "pkg-author.", "nobody");
        LICENSE = Jindolf.getPackageInfo(verProp, "pkg-license.", "Unknown");
        CONTACT = Jindolf.getPackageInfo(verProp, "pkg-contact.", "Unknown");
        DEBUT = Jindolf.getPackageInfo(verProp, "pkg-debut.", "2008");
        COMMENT = Jindolf.getPackageInfo(verProp, "pkg-comment.", "");
        COPYRIGHT = "Copyright(c) " + DEBUT + " " + AUTHOR;
        ID = TITLE + " " + "Ver." + VERSION + " " + COPYRIGHT + " " + "(" + LICENSE + ")";
        Logger jre14Logger = Logger.getLogger(SELF_PACKAGE.getName());
        COMMON_LOGGER = new LogWrapper(jre14Logger);
        INVOKE_FLAG = new AtomicBoolean(false);
        new Jindolf();
    }
}

