/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import jp.sourceforge.jindolf.HttpUtils;
import jp.sourceforge.jindolf.Jindolf;

public class TallyInputStream
extends InputStream {
    private static final int BUFSIZE = 2048;
    private final HttpURLConnection conn;
    private final InputStream in;
    private long counter;
    private long nanoLap;
    private boolean hasClosed;

    public static InputStream getInputStream(HttpURLConnection conn) throws IOException {
        return new TallyInputStream(conn);
    }

    protected TallyInputStream(HttpURLConnection conn) throws IOException {
        this.conn = conn;
        this.counter = 0L;
        this.nanoLap = 0L;
        InputStream is = this.conn.getInputStream();
        this.in = is = new BufferedInputStream(is, 2048);
        this.hasClosed = false;
    }

    protected long getCount() {
        return this.counter;
    }

    public int available() throws IOException {
        int bytes = this.in.available();
        return bytes;
    }

    public void close() throws IOException {
        if (this.hasClosed) {
            return;
        }
        this.in.close();
        long size = this.getCount();
        long span = System.nanoTime() - this.nanoLap;
        String message = HttpUtils.formatHttpStat(this.conn, size, span);
        Jindolf.logger().info(message);
        this.hasClosed = true;
    }

    public int read() throws IOException {
        int byteData;
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        if ((byteData = this.in.read()) >= 0) {
            ++this.counter;
        }
        return byteData;
    }

    public int read(byte[] buf) throws IOException {
        int count;
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        if ((count = this.in.read(buf)) >= 0) {
            this.counter += (long)count;
        }
        return count;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int count;
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        if ((count = this.in.read(buf, off, len)) >= 0) {
            this.counter += (long)count;
        }
        return count;
    }

    public long skip(long n) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        long skipped = this.in.skip(n);
        this.counter += skipped;
        return skipped;
    }
}

