/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.jindolf.FontInfo;
import jp.sourceforge.jindolf.FontUtils;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Monodizer;
import jp.sourceforge.jindolf.TextPopup;

public class FontChooser
extends JPanel
implements ListSelectionListener,
ActionListener,
ItemListener {
    private static final Integer[] POINT_SIZES;
    private static final CharSequence PREVIEW_CONTENT;
    private FontInfo fontInfo;
    private FontInfo lastFontInfo;
    private final JList familySelector;
    private final JComboBox sizeSelector;
    private final JCheckBox isBoldCheck;
    private final JCheckBox isItalicCheck;
    private final JCheckBox useTextAntiAliaseCheck;
    private final JCheckBox useFractionalCheck;
    private final JLabel maxBounds;
    private final JTextField decodeName;
    private final FontPreview preview;
    private final JButton resetDefault;
    private boolean maskListener = false;

    public FontChooser() {
        this(FontInfo.DEFAULT_FONTINFO);
    }

    public FontChooser(FontInfo fontInfo) throws NullPointerException {
        if (fontInfo == null) {
            throw new NullPointerException();
        }
        this.fontInfo = fontInfo;
        this.lastFontInfo = fontInfo;
        Jindolf.logger().info("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u306b" + this.fontInfo.getFont() + "\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f");
        Jindolf.logger().info("\u767a\u8a00\u8868\u793a\u306e\u30a2\u30f3\u30c1\u30a8\u30a4\u30ea\u30a2\u30b9\u6307\u5b9a\u306b" + this.fontInfo.getFontRenderContext().isAntiAliased() + "\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        Jindolf.logger().info("\u767a\u8a00\u8868\u793a\u306eFractional\u6307\u5b9a\u306b" + this.fontInfo.getFontRenderContext().usesFractionalMetrics() + "\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        this.familySelector = new JList<Object>(FontUtils.createFontSet().toArray());
        this.familySelector.setVisibleRowCount(-1);
        this.familySelector.setSelectionMode(0);
        this.sizeSelector = new JComboBox();
        this.sizeSelector.setEditable(true);
        this.sizeSelector.setActionCommand("FONTSIZESEL");
        for (Integer size : POINT_SIZES) {
            this.sizeSelector.addItem(size);
        }
        this.isBoldCheck = new JCheckBox("\u30dc\u30fc\u30eb\u30c9");
        this.isItalicCheck = new JCheckBox("\u30a4\u30bf\u30ea\u30c3\u30af");
        this.useTextAntiAliaseCheck = new JCheckBox("\u30a2\u30f3\u30c1\u30a8\u30a4\u30ea\u30a2\u30b9");
        this.useFractionalCheck = new JCheckBox("\u30b5\u30d6\u30d4\u30af\u30bb\u30eb\u7cbe\u5ea6");
        this.maxBounds = new JLabel();
        this.decodeName = new JTextField();
        this.decodeName.setEditable(false);
        this.decodeName.setMargin(new Insets(1, 4, 1, 4));
        this.decodeName.setComponentPopupMenu(new TextPopup());
        Monodizer.monodize(this.decodeName);
        this.preview = new FontPreview(PREVIEW_CONTENT, this.fontInfo);
        this.resetDefault = new JButton("\u51fa\u8377\u6642\u306b\u623b\u3059");
        this.resetDefault.addActionListener(this);
        this.design(this);
        this.updateControlls();
        this.updatePreview();
        this.familySelector.addListSelectionListener(this);
        this.sizeSelector.addActionListener(this);
        this.isBoldCheck.addItemListener(this);
        this.isItalicCheck.addItemListener(this);
        this.useTextAntiAliaseCheck.addItemListener(this);
        this.useFractionalCheck.addItemListener(this);
    }

    private void design(Container content) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        JComponent fontPref = this.createFontPrefPanel();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        content.add((Component)fontPref, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        TitledBorder border = BorderFactory.createTitledBorder("\u30d7\u30ec\u30d3\u30e5\u30fc");
        JPanel panel = new JPanel();
        panel.add(this.preview);
        panel.setBorder(border);
        content.add((Component)this.createPreviewPanel(), constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)this.createFontDecodePanel(), constraints);
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        content.add((Component)this.maxBounds, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)this.resetDefault, constraints);
    }

    private JComponent createFontPrefPanel() {
        JPanel result = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        result.setLayout(layout);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 0;
        constraints.fill = 1;
        Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.familySelector.setBorder(border);
        JScrollPane familyScroller = new JScrollPane(this.familySelector);
        border = BorderFactory.createTitledBorder("\u30d5\u30a9\u30f3\u30c8\u30d5\u30a1\u30df\u30ea\u9078\u629e");
        JPanel familyPanel = new JPanel();
        familyPanel.setLayout(new BorderLayout());
        familyPanel.add((Component)familyScroller, "Center");
        familyPanel.setBorder(border);
        result.add((Component)familyPanel, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 0.0;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        border = BorderFactory.createTitledBorder("\u30dd\u30a4\u30f3\u30c8\u30b5\u30a4\u30ba\u6307\u5b9a");
        JPanel panel = new JPanel();
        panel.add(this.sizeSelector);
        panel.setBorder(border);
        result.add((Component)panel, constraints);
        constraints.anchor = 18;
        result.add((Component)this.isBoldCheck, constraints);
        result.add((Component)this.isItalicCheck, constraints);
        result.add((Component)this.useTextAntiAliaseCheck, constraints);
        result.add((Component)this.useFractionalCheck, constraints);
        return result;
    }

    private JComponent createPreviewPanel() {
        JPanel result = new JPanel();
        JScrollPane scroller = new JScrollPane(this.preview);
        scroller.getVerticalScrollBar().setUnitIncrement(8);
        TitledBorder border = BorderFactory.createTitledBorder("\u30d7\u30ec\u30d3\u30e5\u30fc");
        result.setBorder(border);
        result.setLayout(new BorderLayout());
        result.add((Component)scroller, "Center");
        return result;
    }

    private JComponent createFontDecodePanel() {
        JPanel result = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        result.setLayout(layout);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        result.add((Component)new JLabel("Font.deode() \u8b58\u5225\u540d:"), constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        result.add((Component)this.decodeName, constraints);
        return result;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void setFontInfo(FontInfo newInfo) throws NullPointerException {
        if (newInfo == null) {
            throw new NullPointerException();
        }
        FontInfo old = this.fontInfo;
        if (old.equals(newInfo)) {
            return;
        }
        this.fontInfo = newInfo;
        this.updateControlls();
        this.updatePreview();
    }

    private Font getSelectedFont() {
        return this.fontInfo.getFont();
    }

    protected FontRenderContext getFontRenderContext() {
        return this.fontInfo.getFontRenderContext();
    }

    private void updatePreview() {
        this.preview.setFontInfo(this.fontInfo);
    }

    private void updateControlls() {
        this.maskListener = true;
        Font currentFont = this.getSelectedFont();
        FontRenderContext currentContext = this.getFontRenderContext();
        String defaultFamily = currentFont.getFamily();
        this.familySelector.setSelectedValue(defaultFamily, true);
        Integer selectedInteger = currentFont.getSize();
        this.sizeSelector.setSelectedItem(selectedInteger);
        int sizeItems = this.sizeSelector.getItemCount();
        for (int index = 0; index <= sizeItems - 1; ++index) {
            Object sizeItem = this.sizeSelector.getItemAt(index);
            if (!sizeItem.equals(selectedInteger)) continue;
            this.sizeSelector.setSelectedIndex(index);
            break;
        }
        this.isBoldCheck.setSelected(currentFont.isBold());
        this.isItalicCheck.setSelected(currentFont.isItalic());
        this.useTextAntiAliaseCheck.setSelected(currentContext.isAntiAliased());
        this.useFractionalCheck.setSelected(currentContext.usesFractionalMetrics());
        this.decodeName.setText(FontUtils.getFontDecodeName(currentFont));
        this.decodeName.setCaretPosition(0);
        Rectangle2D r2d = currentFont.getMaxCharBounds(currentContext);
        Rectangle rect = r2d.getBounds();
        String boundInfo = "\u6700\u5927\u6587\u5b57\u5bf8\u6cd5 : " + rect.width + " pixel\u5e45 \u00d7 " + rect.height + " pixel\u9ad8";
        this.maxBounds.setText(boundInfo);
        this.maskListener = false;
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.updateControlls();
            this.updatePreview();
        }
        this.lastFontInfo = this.fontInfo;
        super.setVisible(isVisible);
    }

    public void itemStateChanged(ItemEvent event) {
        Font newFont;
        if (this.maskListener) {
            return;
        }
        Object source = event.getSource();
        if (source != this.isBoldCheck && source != this.isItalicCheck && source != this.useTextAntiAliaseCheck && source != this.useFractionalCheck) {
            return;
        }
        int style = 0;
        if (this.isBoldCheck.isSelected()) {
            style |= 1;
        }
        if (this.isItalicCheck.isSelected()) {
            style |= 2;
        }
        if ((newFont = this.getSelectedFont()).getStyle() != style) {
            newFont = newFont.deriveFont(style);
        }
        AffineTransform tx = this.getFontRenderContext().getTransform();
        boolean isAntiAliases = this.useTextAntiAliaseCheck.isSelected();
        boolean useFractional = this.useFractionalCheck.isSelected();
        FontRenderContext newContext = new FontRenderContext(tx, isAntiAliases, useFractional);
        FontInfo newInfo = new FontInfo(newFont, newContext);
        this.setFontInfo(newInfo);
    }

    private void actionFontSizeSelected() {
        Integer selectedInteger;
        Object selected = this.sizeSelector.getSelectedItem();
        if (selected == null) {
            return;
        }
        if (selected instanceof Integer) {
            selectedInteger = (Integer)selected;
        } else {
            try {
                selectedInteger = Integer.valueOf(selected.toString());
            }
            catch (NumberFormatException e) {
                selectedInteger = this.lastFontInfo.getFont().getSize();
            }
        }
        if (selectedInteger <= 0) {
            selectedInteger = this.lastFontInfo.getFont().getSize();
        }
        float fontSize = selectedInteger.floatValue();
        Font newFont = this.getSelectedFont().deriveFont(fontSize);
        FontInfo newInfo = this.fontInfo.deriveFont(newFont);
        this.setFontInfo(newInfo);
        int sizeItems = this.sizeSelector.getItemCount();
        for (int index = 0; index <= sizeItems - 1; ++index) {
            Object sizeItem = this.sizeSelector.getItemAt(index);
            if (!sizeItem.equals(selectedInteger)) continue;
            this.sizeSelector.setSelectedIndex(index);
            break;
        }
        this.updateControlls();
        this.updatePreview();
    }

    public void actionPerformed(ActionEvent event) {
        Object source;
        if (this.maskListener) {
            return;
        }
        String cmd = event.getActionCommand();
        if (cmd.equals("FONTSIZESEL")) {
            this.actionFontSizeSelected();
        }
        if ((source = event.getSource()) == this.resetDefault) {
            this.setFontInfo(FontInfo.DEFAULT_FONTINFO);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (this.maskListener) {
            return;
        }
        if (event.getSource() != this.familySelector) {
            return;
        }
        if (event.getValueIsAdjusting()) {
            return;
        }
        Object selected = this.familySelector.getSelectedValue();
        if (selected == null) {
            return;
        }
        String familyName = selected.toString();
        Font currentFont = this.getSelectedFont();
        int style = currentFont.getStyle();
        int size = currentFont.getSize();
        Font newFont = new Font(familyName, style, size);
        FontInfo newInfo = this.fontInfo.deriveFont(newFont);
        this.setFontInfo(newInfo);
    }

    static {
        CharSequence resourceText;
        POINT_SIZES = new Integer[]{8, 10, 12, 16, 18, 24, 32, 36, 48, 72};
        try {
            resourceText = Jindolf.loadResourceText("resources/preview.txt");
        }
        catch (IOException e) {
            resourceText = "ABC";
        }
        PREVIEW_CONTENT = resourceText;
    }

    private static class FontPreview
    extends JComponent {
        private static final int MARGIN = 5;
        private final GlyphDraw draw;
        private FontInfo fontInfo;

        public FontPreview(CharSequence source, FontInfo fontInfo) {
            this.fontInfo = fontInfo;
            this.draw = new GlyphDraw(source, this.fontInfo);
            this.draw.setFontInfo(this.fontInfo);
            this.draw.setPos(5, 5);
            this.draw.setColor(Color.BLACK);
            this.setBackground(Color.WHITE);
            this.updateBounds();
        }

        private void updateBounds() {
            Rectangle bounds = this.draw.setWidth(Integer.MAX_VALUE);
            Dimension dimension = new Dimension(bounds.width + 10, bounds.height + 10);
            this.setPreferredSize(dimension);
            this.revalidate();
            this.repaint();
        }

        public void setFontInfo(FontInfo newFontInfo) {
            this.fontInfo = newFontInfo;
            this.draw.setFontInfo(this.fontInfo);
            this.updateBounds();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            this.draw.paint(g2d);
        }
    }
}

