/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Monodizer;
import jp.sourceforge.jindolf.ProxyInfo;
import jp.sourceforge.jindolf.TextPopup;

public class ProxyChooser
extends JPanel
implements ItemListener {
    private final JRadioButton isDirect = new JRadioButton("\u76f4\u63a5\u63a5\u7d9a");
    private final JRadioButton isHttp = new JRadioButton("HTTP-Proxy (RFC2616)");
    private final JRadioButton isSocks = new JRadioButton("SOCKS (RFC1928)");
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JTextField hostname = new JTextField();
    private final JComboBox port = new JComboBox();
    private final JComponent serverInfo = this.buildServerPanel();

    private static ComboBoxModel buildPortRecommender() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("80");
        model.addElement("1080");
        model.addElement("3128");
        model.addElement("8000");
        model.addElement("8080");
        model.addElement("10080");
        return model;
    }

    public ProxyChooser() {
        this(ProxyInfo.DEFAULT);
    }

    public ProxyChooser(ProxyInfo proxyInfo) {
        this.buttonGroup.add(this.isDirect);
        this.buttonGroup.add(this.isHttp);
        this.buttonGroup.add(this.isSocks);
        this.isDirect.addItemListener(this);
        this.isHttp.addItemListener(this);
        this.isSocks.addItemListener(this);
        this.hostname.setComponentPopupMenu(new TextPopup());
        Monodizer.monodize(this.hostname);
        GUIUtils.addMargin(this.hostname, 1, 4, 1, 4);
        this.port.setModel(ProxyChooser.buildPortRecommender());
        this.port.setEditable(true);
        ComboBoxEditor editor = this.port.getEditor();
        Component comp = editor.getEditorComponent();
        GUIUtils.addMargin(comp, 1, 4, 1, 4);
        if (comp instanceof JComponent) {
            ((JComponent)comp).setComponentPopupMenu(new TextPopup());
        }
        Monodizer.monodize(this.port);
        this.design(this);
        this.setProxyInfo(proxyInfo);
    }

    private void design(Container content) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        content.add((Component)this.isDirect, constraints);
        content.add((Component)this.isHttp, constraints);
        content.add((Component)this.isSocks, constraints);
        content.add((Component)this.serverInfo, constraints);
        constraints.weighty = 1.0;
        content.add((Component)new JPanel(), constraints);
    }

    private JComponent buildServerPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 12;
        panel.add((Component)new JLabel("\u30a2\u30c9\u30ec\u30b9:"), constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        panel.add((Component)this.hostname, constraints);
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 12;
        panel.add((Component)new JLabel("\u30dd\u30fc\u30c8:"), constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        panel.add((Component)this.port, constraints);
        String warn = "<html>\u203b \u3053\u306e\u30d7\u30ed\u30af\u30b7\u30b5\u30fc\u30d0\u306f\u672c\u5f53\u306b\u4fe1\u983c\u3067\u304d\u307e\u3059\u304b\uff1f<br>\u3042\u306a\u305f\u304c\u4eba\u72fcBBS\u306b\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u308b\u9593\u3001<br>\u3042\u306a\u305f\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u306f\u5e73\u6587\u72b6\u614b\u306e\u307e\u307e<br>\u3053\u306e\u30d7\u30ed\u30af\u30b7\u30b5\u30fc\u30d0\u4e0a\u3092\u4f55\u5ea6\u3082\u901a\u904e\u3057\u307e\u3059\u3002</html>";
        panel.add((Component)new JLabel(warn), constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u30d7\u30ed\u30af\u30b7\u30b5\u30fc\u30d0\u60c5\u5831");
        panel.setBorder(border);
        return panel;
    }

    protected Proxy.Type getType() {
        if (this.isDirect.isSelected()) {
            return Proxy.Type.DIRECT;
        }
        if (this.isHttp.isSelected()) {
            return Proxy.Type.HTTP;
        }
        if (this.isSocks.isSelected()) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.DIRECT;
    }

    protected String getHostName() {
        String hostText = this.hostname.getText();
        hostText = hostText.trim();
        return hostText;
    }

    protected int getPort() {
        int result;
        Object portItem = this.port.getEditor().getItem();
        String portText = portItem.toString();
        portText = portText.trim();
        try {
            result = Integer.parseInt(portText);
        }
        catch (NumberFormatException e) {
            return 0;
        }
        if (result < 0) {
            result = 0;
        }
        if (65535 < result) {
            result = 65535;
        }
        return result;
    }

    protected InetSocketAddress getInetSocketAddress() {
        return InetSocketAddress.createUnresolved(this.getHostName(), this.getPort());
    }

    public ProxyInfo getProxyInfo() {
        Proxy.Type type = this.getType();
        return new ProxyInfo(type, this.getInetSocketAddress());
    }

    public final void setProxyInfo(ProxyInfo proxyInfo) {
        ButtonModel model;
        InetSocketAddress addr;
        Proxy.Type type;
        if (proxyInfo == null) {
            type = Proxy.Type.DIRECT;
            addr = ProxyInfo.IP4SOCKET_NOBODY;
        } else {
            type = proxyInfo.getType();
            addr = proxyInfo.address();
        }
        switch (type) {
            case DIRECT: {
                model = this.isDirect.getModel();
                break;
            }
            case HTTP: {
                model = this.isHttp.getModel();
                break;
            }
            case SOCKS: {
                model = this.isSocks.getModel();
                break;
            }
            default: {
                model = this.isDirect.getModel();
            }
        }
        this.buttonGroup.setSelected(model, true);
        this.hostname.setText(addr.getHostName());
        this.port.getEditor().setItem(addr.getPort());
    }

    public void itemStateChanged(ItemEvent event) {
        Proxy.Type type;
        Object source = event.getSource();
        if (source == this.isDirect) {
            type = Proxy.Type.DIRECT;
        } else if (source == this.isHttp) {
            type = Proxy.Type.HTTP;
        } else if (source == this.isSocks) {
            type = Proxy.Type.SOCKS;
        } else {
            return;
        }
        if (type == Proxy.Type.DIRECT) {
            this.hostname.setEnabled(false);
            this.port.setEnabled(false);
        } else {
            this.hostname.setEnabled(true);
            this.port.setEnabled(true);
        }
    }
}

