/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sourceforge.jindolf.Village;

public class VillageInfoPanel
extends JPanel {
    private Village village;
    private final JLabel landName = new JLabel();
    private final JLabel villageName = new JLabel();
    private final JLabel villageID = new JLabel();
    private final JLabel state = new JLabel();
    private final JLabel days = new JLabel();
    private final JLabel limit = new JLabel();
    private final JLabel limitCaption = new JLabel();

    public VillageInfoPanel() {
        this.design();
        this.updateVillage(null);
    }

    private void design() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.add((Component)new JLabel("\u56fd\u540d : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.add((Component)this.landName, constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.add((Component)new JLabel("\u6751\u540d : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.add((Component)this.villageName, constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.add((Component)new JLabel("\u6751ID : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.add((Component)this.villageID, constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.add((Component)new JLabel("\u72b6\u614b : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.add((Component)this.state, constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.add((Component)new JLabel("\u6240\u8981\u65e5\u6570 : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.add((Component)this.days, constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.add((Component)this.limitCaption, constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.add((Component)this.limit, constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        this.add((Component)new JPanel(), constraints);
    }

    public Village getVillage() {
        return this.village;
    }

    public final void updateVillage(Village villageArg) {
        String caption;
        String daysInfo;
        String status;
        this.village = villageArg;
        if (this.village == null) {
            this.landName.setText("???");
            this.villageName.setText("???");
            this.villageID.setText("???");
            this.state.setText("???");
            this.days.setText("???");
            this.limit.setText("???");
            this.limitCaption.setText("\u66f4\u65b0\u65e5\u6642 : ");
            return;
        }
        String land = this.village.getParentLand().getLandDef().getLandName();
        String vName = "\u300c" + this.village.getVillageFullName() + "\u300d";
        String vID = this.village.getVillageID();
        int progressDays = this.village.getProgressDays();
        switch (this.village.getState()) {
            case PROLOGUE: {
                status = "\u30d7\u30ed\u30ed\u30fc\u30b0\u4e2d";
                daysInfo = "\u30d7\u30ed\u30ed\u30fc\u30b0\u4e2d";
                caption = "\u30d7\u30ed\u30ed\u30fc\u30b0\u7d42\u4e86\u4e88\u60f3 : ";
                break;
            }
            case PROGRESS: {
                status = "\u30b2\u30fc\u30e0\u9032\u884c\u4e2d";
                daysInfo = "\u30d7\u30ed\u30ed\u30fc\u30b0 + " + progressDays + "\u65e5\u76ee";
                caption = "\u66f4\u65b0\u65e5\u6642 : ";
                break;
            }
            case EPILOGUE: {
                status = "\u30a8\u30d4\u30ed\u30fc\u30b0\u4e2d";
                daysInfo = "\u30d7\u30ed\u30ed\u30fc\u30b0 + " + progressDays + "\u65e5 + \u30a8\u30d4\u30ed\u30fc\u30b0\u4e2d";
                caption = "\u30a8\u30d4\u30ed\u30fc\u30b0\u7d42\u4e86\u4e88\u60f3 : ";
                break;
            }
            case GAMEOVER: {
                status = "\u30b2\u30fc\u30e0\u7d42\u4e86";
                daysInfo = "\u30d7\u30ed\u30ed\u30fc\u30b0 + " + progressDays + "\u65e5 + \u30a8\u30d4\u30ed\u30fc\u30b0";
                caption = "\u30a8\u30d4\u30ed\u30fc\u30b0\u7d42\u4e86\u65e5\u6642 : ";
                break;
            }
            case UNKNOWN: {
                status = "\u4e0d\u660e";
                daysInfo = "\u4e0d\u660e";
                caption = "\u66f4\u65b0\u65e5\u6642 : ";
                break;
            }
            default: {
                assert (false);
                status = "???";
                daysInfo = "???";
                caption = "\u66f4\u65b0\u65e5\u6642 : ";
            }
        }
        int limitMonth = this.village.getLimitMonth();
        int limitDay = this.village.getLimitDay();
        int limitHour = this.village.getLimitHour();
        int limitMinute = this.village.getLimitMinute();
        String limitDate = limitMonth + "\u6708" + limitDay + "\u65e5";
        String limitTime = "";
        if (limitHour < 10) {
            limitTime = limitTime + "0";
        }
        limitTime = limitTime + limitHour + ":";
        if (limitMinute < 10) {
            limitTime = limitTime + "0";
        }
        limitTime = limitTime + limitMinute;
        this.landName.setText(land);
        this.villageName.setText(vName);
        this.villageID.setText(vID);
        this.state.setText(status);
        this.days.setText(daysInfo);
        this.limit.setText(limitDate + " " + limitTime);
        this.limitCaption.setText(caption);
    }
}

