/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.HtmlSequence;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.StringUtils;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.corelib.TalkType;
import jp.sourceforge.jindolf.corelib.Team;
import jp.sourceforge.jindolf.corelib.VillageState;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.EntityConverter;
import jp.sourceforge.jindolf.parser.HtmlAdapter;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.HtmlParser;
import jp.sourceforge.jindolf.parser.PageType;
import jp.sourceforge.jindolf.parser.SeqRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period {
    private static final HtmlParser PARSER = new HtmlParser();
    private static final PeriodHandler HANDLER = new PeriodHandler();
    private final Village homeVillage;
    private final PeriodType periodType;
    private final int day;
    private int limitHour;
    private int limitMinute;
    private String loginName;
    private boolean isFullOpen = false;
    private final List<Topic> topicList = new LinkedList<Topic>();
    private final List<Topic> unmodList = Collections.unmodifiableList(this.topicList);
    private boolean isHot;

    public static void parsePeriod(Period period, boolean force) throws IOException {
        if (!force && period.hasLoaded()) {
            return;
        }
        Village village = period.getVillage();
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        period.isFullOpen = village.getState() != VillageState.PROGRESS ? true : period.getType() != PeriodType.PROGRESS;
        HtmlSequence html = server.getHTMLPeriod(period);
        period.topicList.clear();
        boolean wasHot = period.isHot();
        HANDLER.setPeriod(period);
        DecodedContent content = html.getContent();
        try {
            PARSER.parseAutomatic(content);
        }
        catch (HtmlParseException e) {
            Jindolf.logger().warn("\u767a\u8a00\u62bd\u51fa\u306b\u5931\u6557", e);
        }
        if (wasHot && !period.isHot()) {
            Period.parsePeriod(period, true);
            return;
        }
    }

    public Period(Village homeVillage, PeriodType periodType, int day) throws NullPointerException {
        this(homeVillage, periodType, day, false);
    }

    private Period(Village homeVillage, PeriodType periodType, int day, boolean isHot) throws NullPointerException {
        if (homeVillage == null || periodType == null) {
            throw new NullPointerException();
        }
        if (day < 0) {
            throw new IllegalArgumentException("Period day is too small !");
        }
        switch (periodType) {
            case PROLOGUE: {
                assert (day == 0);
                break;
            }
            case PROGRESS: 
            case EPILOGUE: {
                assert (day > 0);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.homeVillage = homeVillage;
        this.periodType = periodType;
        this.day = day;
        this.unload();
        this.isHot = isHot;
    }

    public Village getVillage() {
        return this.homeVillage;
    }

    public PeriodType getType() {
        return this.periodType;
    }

    public int getDay() {
        return this.day;
    }

    public String getLimit() {
        StringBuilder result = new StringBuilder();
        if (this.limitHour < 10) {
            result.append('0');
        }
        result.append(this.limitHour).append(':');
        if (this.limitMinute < 10) {
            result.append('0');
        }
        result.append(this.limitMinute);
        return result.toString();
    }

    public boolean isHot() {
        return this.isHot;
    }

    public void setHot(boolean isHotArg) {
        this.isHot = isHotArg;
    }

    public boolean isPrologue() {
        return this.getType() == PeriodType.PROLOGUE;
    }

    public boolean isEpilogue() {
        return this.getType() == PeriodType.EPILOGUE;
    }

    public boolean isProgress() {
        return this.getType() == PeriodType.PROGRESS;
    }

    public String getCGIQuery() {
        StringBuilder result = new StringBuilder();
        Village village = this.getVillage();
        result.append(village.getCGIQuery());
        if (this.isHot()) {
            result.append("&mes=all");
            return result.toString();
        }
        Land land = village.getParentLand();
        LandDef ldef = land.getLandDef();
        if (ldef.getLandId().equals("wolfg")) {
            result.append("&meslog=");
            String dnum = "000" + (this.getDay() - 1);
            dnum = dnum.substring(dnum.length() - 3);
            switch (this.getType()) {
                case PROLOGUE: {
                    result.append("000_ready");
                    break;
                }
                case PROGRESS: {
                    result.append(dnum).append("_progress");
                    break;
                }
                case EPILOGUE: {
                    result.append(dnum).append("_party");
                    break;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
        } else {
            result.append("&meslog=").append(village.getVillageID());
            switch (this.getType()) {
                case PROLOGUE: {
                    result.append("_ready_0");
                    break;
                }
                case PROGRESS: {
                    result.append("_progress_").append(this.getDay() - 1);
                    break;
                }
                case EPILOGUE: {
                    result.append("_party_").append(this.getDay() - 1);
                    break;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
        }
        result.append("&mes=all");
        return result.toString();
    }

    public List<Topic> getTopicList() {
        return this.unmodList;
    }

    public int getTopics() {
        return this.topicList.size();
    }

    protected void addTopic(Topic topic) throws NullPointerException {
        if (topic == null) {
            throw new NullPointerException();
        }
        this.topicList.add(topic);
    }

    public String getCaption() {
        String result;
        switch (this.getType()) {
            case PROLOGUE: {
                result = "\u30d7\u30ed\u30ed\u30fc\u30b0";
                break;
            }
            case PROGRESS: {
                result = this.getDay() + "\u65e5\u76ee";
                break;
            }
            case EPILOGUE: {
                result = "\u30a8\u30d4\u30ed\u30fc\u30b0";
                break;
            }
            default: {
                assert (false);
                result = null;
            }
        }
        return result;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public Talk getNumberedTalk(int talkNo) {
        if (talkNo <= 0) {
            throw new IllegalArgumentException();
        }
        for (Topic topic : this.topicList) {
            Talk talk;
            if (!(topic instanceof Talk) || talkNo != (talk = (Talk)topic).getTalkNo()) continue;
            return talk;
        }
        return null;
    }

    public boolean isFullOpen() {
        return this.isFullOpen;
    }

    public boolean hasLoaded() {
        return this.getTopics() > 0;
    }

    public void unload() {
        this.limitHour = 0;
        this.limitMinute = 0;
        this.loginName = null;
        this.isFullOpen = false;
        this.isHot = false;
        this.topicList.clear();
    }

    public boolean hasAssaultTried() {
        for (Topic topic : this.topicList) {
            SysEvent sysEvent;
            SysEventType type;
            Talk talk;
            if (!(topic instanceof Talk ? (talk = (Talk)topic).getTalkCount() <= 0 : topic instanceof SysEvent && (type = (sysEvent = (SysEvent)topic).getSysEventType()) == SysEventType.ASSAULT)) continue;
            return true;
        }
        return false;
    }

    public Avatar getExecutedAvatar() {
        Avatar result = null;
        for (Topic topic : this.getTopicList()) {
            SysEvent event;
            if (topic instanceof SysEvent && (result = (event = (SysEvent)topic).getExecutedAvatar()) != null) break;
        }
        return result;
    }

    public Set<Avatar> getVoterSet() {
        Set<Avatar> result = new HashSet<Avatar>();
        for (Topic topic : this.getTopicList()) {
            if (!(topic instanceof SysEvent)) continue;
            SysEvent event = (SysEvent)topic;
            result = event.getVoterSet(result);
        }
        return result;
    }

    public SysEvent getTypedSysEvent(SysEventType type) {
        for (Topic topic : this.getTopicList()) {
            SysEvent event;
            if (!(topic instanceof SysEvent) || (event = (SysEvent)topic).getSysEventType() != type) continue;
            return event;
        }
        return null;
    }

    static {
        PARSER.setBasicHandler(HANDLER);
        PARSER.setSysEventHandler(HANDLER);
        PARSER.setTalkHandler(HANDLER);
    }

    private static class PeriodHandler
    extends HtmlAdapter {
        private static final int TALKTYPE_NUM = TalkType.values().length;
        private final EntityConverter converter = new EntityConverter();
        private final Map<Avatar, int[]> countMap = new HashMap<Avatar, int[]>();
        private Period period = null;
        private TalkType talkType;
        private Avatar avatar;
        private int talkNo;
        private String anchorId;
        private int talkHour;
        private int talkMinute;
        private DecodedContent talkContent = null;
        private EventFamily eventFamily;
        private SysEventType sysEventType;
        private DecodedContent eventContent = null;
        private final List<Avatar> avatarList = new LinkedList<Avatar>();
        private final List<GameRole> roleList = new LinkedList<GameRole>();
        private final List<Integer> integerList = new LinkedList<Integer>();
        private final List<CharSequence> charseqList = new LinkedList<CharSequence>();

        public void setPeriod(Period period) {
            this.period = period;
        }

        private Avatar toAvatar(DecodedContent content, SeqRange range) {
            String fullName;
            Village village = this.period.getVillage();
            Avatar result = village.getAvatar(fullName = this.converter.convert(content, range).toString());
            if (result == null) {
                result = new Avatar(fullName);
                village.addAvatar(result);
            }
            return result;
        }

        private int countUp(Avatar targetAvatar, TalkType targetType) {
            int[] countArray = this.countMap.get(targetAvatar);
            if (countArray == null) {
                countArray = new int[TALKTYPE_NUM];
                this.countMap.put(targetAvatar, countArray);
            }
            int n = targetType.ordinal();
            int n2 = countArray[n] + 1;
            countArray[n] = n2;
            int count = n2;
            return count;
        }

        public void startParse(DecodedContent content) throws HtmlParseException {
            this.period.loginName = null;
            this.period.topicList.clear();
            this.countMap.clear();
        }

        public void loginName(DecodedContent content, SeqRange loginRange) throws HtmlParseException {
            DecodedContent loginName = this.converter.convert(content, loginRange);
            this.period.loginName = loginName.toString();
        }

        public void pageType(PageType type) throws HtmlParseException {
            if (type != PageType.PERIOD_PAGE) {
                throw new HtmlParseException("\u610f\u56f3\u3057\u306a\u3044\u30da\u30fc\u30b8\u3092\u8aad\u307f\u8fbc\u3082\u3046\u3068\u3057\u307e\u3057\u305f\u3002");
            }
        }

        public void commitTime(int month, int day, int hour, int minute) throws HtmlParseException {
            this.period.limitHour = hour;
            this.period.limitMinute = minute;
        }

        public void periodLink(DecodedContent content, SeqRange anchorRange, PeriodType periodType, int day) throws HtmlParseException {
            if (this.period.getType() != periodType) {
                return;
            }
            if (periodType == PeriodType.PROGRESS && this.period.getDay() != day) {
                return;
            }
            if (!anchorRange.isValid()) {
                return;
            }
            this.period.setHot(false);
        }

        public void startTalk() throws HtmlParseException {
            this.talkType = null;
            this.avatar = null;
            this.talkNo = -1;
            this.anchorId = null;
            this.talkHour = -1;
            this.talkMinute = -1;
            this.talkContent = new DecodedContent(101);
        }

        public void talkType(TalkType type) throws HtmlParseException {
            this.talkType = type;
        }

        public void talkAvatar(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
            this.avatar = this.toAvatar(content, avatarRange);
        }

        public void talkTime(int hour, int minute) throws HtmlParseException {
            this.talkHour = hour;
            this.talkMinute = minute;
        }

        public void talkNo(int tno) throws HtmlParseException {
            this.talkNo = tno;
        }

        public void talkId(DecodedContent content, SeqRange idRange) throws HtmlParseException {
            this.anchorId = ((Object)content.subSequence(idRange.getStartPos(), idRange.getEndPos())).toString();
        }

        public void talkText(DecodedContent content, SeqRange textRange) throws HtmlParseException {
            this.converter.append(this.talkContent, content, textRange);
        }

        public void talkBreak() throws HtmlParseException {
            this.talkContent.append('\n');
        }

        public void endTalk() throws HtmlParseException {
            Talk talk = new Talk(this.period, this.talkType, this.avatar, this.talkNo, this.anchorId, this.talkHour, this.talkMinute, this.talkContent);
            int count = this.countUp(this.avatar, this.talkType);
            talk.setCount(count);
            this.period.addTopic(talk);
            this.talkType = null;
            this.avatar = null;
            this.talkNo = -1;
            this.anchorId = null;
            this.talkHour = -1;
            this.talkMinute = -1;
            this.talkContent = null;
        }

        public void startSysEvent(EventFamily family) throws HtmlParseException {
            this.eventFamily = family;
            this.sysEventType = null;
            this.eventContent = new DecodedContent();
            this.avatarList.clear();
            this.roleList.clear();
            this.integerList.clear();
            this.charseqList.clear();
        }

        public void sysEventType(SysEventType type) throws HtmlParseException {
            this.sysEventType = type;
        }

        public void sysEventContent(DecodedContent content, SeqRange contentRange) throws HtmlParseException {
            this.converter.append(this.eventContent, content, contentRange);
        }

        public void sysEventContentAnchor(DecodedContent content, SeqRange anchorRange, SeqRange contentRange) throws HtmlParseException {
            this.converter.append(this.eventContent, content, contentRange);
        }

        public void sysEventContentBreak() throws HtmlParseException {
            this.eventContent.append('\n');
        }

        public void sysEventOnStage(DecodedContent content, int entryNo, SeqRange avatarRange) throws HtmlParseException {
            Avatar newAvatar = this.toAvatar(content, avatarRange);
            this.integerList.add(entryNo);
            this.avatarList.add(newAvatar);
        }

        public void sysEventOpenRole(GameRole role, int num) throws HtmlParseException {
            this.roleList.add(role);
            this.integerList.add(num);
        }

        public void sysEventMurdered(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
            Avatar murdered = this.toAvatar(content, avatarRange);
            this.avatarList.add(murdered);
        }

        public void sysEventSurvivor(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
            Avatar survivor = this.toAvatar(content, avatarRange);
            this.avatarList.add(survivor);
        }

        public void sysEventCounting(DecodedContent content, SeqRange voteByRange, SeqRange voteToRange) throws HtmlParseException {
            if (voteByRange.isValid()) {
                Avatar voteBy = this.toAvatar(content, voteByRange);
                this.avatarList.add(voteBy);
            }
            Avatar voteTo = this.toAvatar(content, voteToRange);
            this.avatarList.add(voteTo);
        }

        public void sysEventCounting2(DecodedContent content, SeqRange voteByRange, SeqRange voteToRange) throws HtmlParseException {
            this.sysEventCounting(content, voteByRange, voteToRange);
        }

        public void sysEventSuddenDeath(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
            Avatar suddenDeath = this.toAvatar(content, avatarRange);
            this.avatarList.add(suddenDeath);
        }

        public void sysEventPlayerList(DecodedContent content, SeqRange avatarRange, SeqRange anchorRange, SeqRange loginRange, boolean isLiving, GameRole role) throws HtmlParseException {
            Avatar who = this.toAvatar(content, avatarRange);
            CharSequence anchor = anchorRange.isValid() ? this.converter.convert(content, anchorRange) : "";
            DecodedContent account = this.converter.convert(content, loginRange);
            Integer liveOrDead = isLiving ? Integer.valueOf(1) : Integer.valueOf(0);
            this.avatarList.add(who);
            this.charseqList.add(anchor);
            this.charseqList.add(account);
            this.integerList.add(liveOrDead);
            this.roleList.add(role);
        }

        public void sysEventExecution(DecodedContent content, SeqRange avatarRange, int votes) throws HtmlParseException {
            Avatar who = this.toAvatar(content, avatarRange);
            this.avatarList.add(who);
            this.integerList.add(votes);
        }

        public void sysEventAskEntry(int hour, int minute, int minLimit, int maxLimit) throws HtmlParseException {
            this.integerList.add(hour * 60 + minute);
            this.integerList.add(minLimit);
            this.integerList.add(maxLimit);
        }

        public void sysEventAskCommit(int hour, int minute) throws HtmlParseException {
            this.integerList.add(hour * 60 + minute);
        }

        public void sysEventNoComment(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
            Avatar noComAvatar = this.toAvatar(content, avatarRange);
            this.avatarList.add(noComAvatar);
        }

        public void sysEventStayEpilogue(Team winner, int hour, int minute) throws HtmlParseException {
            GameRole role = null;
            switch (winner) {
                case VILLAGE: {
                    role = GameRole.INNOCENT;
                    break;
                }
                case WOLF: {
                    role = GameRole.WOLF;
                    break;
                }
                case HAMSTER: {
                    role = GameRole.HAMSTER;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.roleList.add(role);
            this.integerList.add(hour * 60 + minute);
        }

        public void sysEventGuard(DecodedContent content, SeqRange guardByRange, SeqRange guardToRange) throws HtmlParseException {
            Avatar guardBy = this.toAvatar(content, guardByRange);
            Avatar guardTo = this.toAvatar(content, guardToRange);
            this.avatarList.add(guardBy);
            this.avatarList.add(guardTo);
        }

        public void sysEventJudge(DecodedContent content, SeqRange judgeByRange, SeqRange judgeToRange) throws HtmlParseException {
            Avatar judgeBy = this.toAvatar(content, judgeByRange);
            Avatar judgeTo = this.toAvatar(content, judgeToRange);
            this.avatarList.add(judgeBy);
            this.avatarList.add(judgeTo);
        }

        public void endSysEvent() throws HtmlParseException {
            SysEvent event = new SysEvent();
            event.setEventFamily(this.eventFamily);
            event.setSysEventType(this.sysEventType);
            event.setContent(this.eventContent);
            event.addAvatarList(this.avatarList);
            event.addRoleList(this.roleList);
            event.addIntegerList(this.integerList);
            event.addCharSequenceList(this.charseqList);
            this.period.addTopic(event);
            if (this.sysEventType == SysEventType.MURDERED || this.sysEventType == SysEventType.NOMURDER) {
                for (Topic topic : this.period.topicList) {
                    Talk talk;
                    if (!(topic instanceof Talk) || (talk = (Talk)topic).getTalkType() != TalkType.WOLFONLY || !StringUtils.isTerminated(talk.getDialog(), "\uff01 \u4eca\u65e5\u304c\u304a\u524d\u306e\u547d\u65e5\u3060\uff01")) continue;
                    talk.setCount(-1);
                    this.countMap.clear();
                }
            }
            this.eventFamily = null;
            this.sysEventType = null;
            this.eventContent = null;
            this.avatarList.clear();
            this.roleList.clear();
            this.integerList.clear();
            this.charseqList.clear();
        }

        public void endParse() throws HtmlParseException {
        }
    }
}

