/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.json;

import jp.sourceforge.jindolf.json.AbstractJsValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsBoolean
extends AbstractJsValue
implements Comparable<JsBoolean> {
    public static final JsBoolean TRUE = new JsBoolean();
    public static final JsBoolean FALSE = new JsBoolean();

    public static JsBoolean valueOf(boolean bool) {
        if (bool) {
            return TRUE;
        }
        return FALSE;
    }

    private JsBoolean() {
    }

    public boolean booleanValue() {
        return this == TRUE;
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public int hashCode() {
        if (this.isTrue()) {
            return Boolean.TRUE.hashCode();
        }
        return Boolean.FALSE.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsBoolean)) {
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(JsBoolean value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this == value) {
            return 0;
        }
        if (this.isTrue() && value.isFalse()) {
            return -1;
        }
        if (this.isFalse() && value.isTrue()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        if (this.isTrue()) {
            return "true";
        }
        return "false";
    }
}

