/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.json;

import java.io.IOException;
import jp.sourceforge.jindolf.json.JsBoolean;
import jp.sourceforge.jindolf.json.JsNumber;
import jp.sourceforge.jindolf.json.JsString;
import jp.sourceforge.jindolf.json.JsValue;

public class JsPair {
    private final String name;
    private final JsValue value;

    public JsPair(String name, JsValue value) throws NullPointerException {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = value;
    }

    public JsPair(String name, CharSequence text) throws NullPointerException {
        this(name, new JsString(text));
    }

    public JsPair(String name, boolean bool) throws NullPointerException {
        this(name, JsBoolean.valueOf(bool));
    }

    public JsPair(String name, long number) throws NullPointerException {
        this(name, new JsNumber(number));
    }

    public JsPair(String name, double number) throws NullPointerException {
        this(name, new JsNumber(number));
    }

    public String getName() {
        return this.name;
    }

    public JsValue getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder text;
        block2: {
            text = new StringBuilder();
            try {
                JsString.writeText(text, this.name);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        text.append(':').append(this.value);
        return text.toString();
    }
}

