/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.util.Comparator;

public class DecodeErrorInfo {
    public static final Comparator<DecodeErrorInfo> POS_COMPARATOR = new PosComparator();
    private final int charPos;
    private final boolean has2ndFlag;
    private final byte rawByte1st;
    private final byte rawByte2nd;

    private DecodeErrorInfo(int charPos, boolean has2ndFlag, byte rawByte1st, byte rawByte2nd) throws IndexOutOfBoundsException {
        if (charPos < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.charPos = charPos;
        this.has2ndFlag = has2ndFlag;
        this.rawByte1st = rawByte1st;
        this.rawByte2nd = rawByte2nd;
    }

    public DecodeErrorInfo(int charPos, byte rawByte1st, byte rawByte2nd) throws IndexOutOfBoundsException {
        this(charPos, true, rawByte1st, rawByte2nd);
    }

    public DecodeErrorInfo(int charPos, byte rawByte1st) throws IndexOutOfBoundsException {
        this(charPos, false, rawByte1st, 0);
    }

    public int getCharPosition() {
        return this.charPos;
    }

    public boolean has2nd() {
        return this.has2ndFlag;
    }

    public byte getRawByte1st() {
        return this.rawByte1st;
    }

    public byte getRawByte2nd() throws IllegalStateException {
        if (!this.has2ndFlag) {
            throw new IllegalStateException();
        }
        return this.rawByte2nd;
    }

    public DecodeErrorInfo createGappedClone(int gap) throws IndexOutOfBoundsException {
        int newPos = this.charPos - gap;
        DecodeErrorInfo result = this.has2ndFlag ? new DecodeErrorInfo(newPos, this.rawByte1st, this.rawByte2nd) : new DecodeErrorInfo(newPos, this.rawByte1st);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("start:").append(this.charPos).append(' ');
        String hex = Integer.toHexString(this.rawByte1st & 0xFF);
        if (hex.length() <= 1) {
            result.append('0');
        }
        result.append(hex);
        if (this.has2ndFlag) {
            hex = Integer.toHexString(this.rawByte2nd & 0xFF);
            result.append(':');
            if (hex.length() <= 1) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PosComparator
    implements Comparator<DecodeErrorInfo> {
        private PosComparator() {
        }

        @Override
        public int compare(DecodeErrorInfo info1, DecodeErrorInfo info2) {
            int pos1 = info1 == null ? -1 : info1.charPos;
            int pos2 = info2 == null ? -1 : info2.charPos;
            return pos1 - pos2;
        }
    }
}

