/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.SeqRange;

public class EntityConverter {
    private static final String[][] XCHG_TABLE = new String[][]{{"&gt;", ">"}, {"&lt;", "<"}, {"&quot;", "\""}, {"&amp;", "&"}, {"\\", "\u00a5"}};
    private static final Pattern XCHG_PATTERN;
    private final Matcher matcher = XCHG_PATTERN.matcher("");

    public DecodedContent convert(DecodedContent content) {
        return this.append(null, content, 0, content.length());
    }

    public DecodedContent convert(DecodedContent content, SeqRange range) throws IndexOutOfBoundsException {
        return this.append(null, content, range.getStartPos(), range.getEndPos());
    }

    public DecodedContent convert(DecodedContent content, int startPos, int endPos) throws IndexOutOfBoundsException {
        return this.append(null, content, startPos, endPos);
    }

    public DecodedContent append(DecodedContent target, DecodedContent content) throws IndexOutOfBoundsException {
        return this.append(target, content, 0, content.length());
    }

    public DecodedContent append(DecodedContent target, DecodedContent content, SeqRange range) throws IndexOutOfBoundsException {
        return this.append(target, content, range.getStartPos(), range.getEndPos());
    }

    public DecodedContent append(DecodedContent target, DecodedContent content, int startPos, int endPos) throws IndexOutOfBoundsException {
        if (startPos > endPos || startPos < 0 || content.length() < endPos) {
            throw new IndexOutOfBoundsException();
        }
        DecodedContent result = target == null ? new DecodedContent(endPos - startPos) : target;
        this.matcher.reset(content.getRawContent());
        this.matcher.region(startPos, endPos);
        int lastPos = startPos;
        while (this.matcher.find()) {
            int group;
            int matchStart = -1;
            for (group = 1; group <= XCHG_TABLE.length && (matchStart = this.matcher.start(group)) < 0; ++group) {
            }
            int matchEnd = this.matcher.end(group);
            result.append(content, lastPos, matchStart);
            String toStr = XCHG_TABLE[group - 1][1];
            result.append(toStr);
            lastPos = matchEnd;
        }
        result.append(content, lastPos, endPos);
        this.matcher.reset("");
        return result;
    }

    static {
        StringBuilder regex = new StringBuilder();
        for (String[] xchg : XCHG_TABLE) {
            String xchgFrom = xchg[0];
            if (regex.length() > 0) {
                regex.append('|');
            }
            regex.append('(').append(Pattern.quote(xchgFrom)).append(')');
            assert (xchgFrom.indexOf(63) < 0);
        }
        XCHG_PATTERN = Pattern.compile(regex.toString());
    }
}

