/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import jp.sourceforge.jindolf.archiver.Handler;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.parser.ContentBuilder;
import jp.sourceforge.jindolf.parser.ContentBuilderSJ;
import jp.sourceforge.jindolf.parser.ContentBuilderUCS2;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.HtmlParser;
import jp.sourceforge.jindolf.parser.SjisDecoder;
import jp.sourceforge.jindolf.parser.StreamDecoder;

public final class Builder {
    private static final int BUF_SZ = 102400;

    public static DecodedContent contentFromStream(Charset charset, InputStream istream) throws IOException, DecodeException {
        ContentBuilder builder;
        StreamDecoder decoder;
        if (charset.name().equalsIgnoreCase("Shift_JIS")) {
            decoder = new SjisDecoder();
            builder = new ContentBuilderSJ(102400);
        } else if (charset.name().equalsIgnoreCase("UTF-8")) {
            decoder = new StreamDecoder(charset.newDecoder());
            builder = new ContentBuilderUCS2(102400);
        } else {
            assert (false);
            return null;
        }
        decoder.setDecodeHandler(builder);
        decoder.decode(istream);
        DecodedContent content = builder.getContent();
        return content;
    }

    public static void fillVillageData(VillageData villageData) throws IOException, DecodeException, HtmlParseException {
        HtmlParser parser = new HtmlParser();
        Handler handler = new Handler();
        parser.setBasicHandler(handler);
        parser.setTalkHandler(handler);
        parser.setSysEventHandler(handler);
        handler.initVillageData(villageData);
        Charset charset = villageData.getLandDef().getEncoding();
        for (PeriodResource resource : villageData.getPeriodResourceList()) {
            handler.initPeriodResource(resource);
            URL url = resource.getResourceUrl();
            if (url == null) {
                url = new URL(resource.getOrigUrlText());
            }
            URLConnection conn = url.openConnection();
            InputStream istream = conn.getInputStream();
            if (resource.getDownTimeMs() <= 0L) {
                long downTimeMs = conn.getDate();
                resource.setDownTimeMs(downTimeMs);
            }
            DecodedContent content = Builder.contentFromStream(charset, istream);
            istream.close();
            parser.parseAutomatic(content);
        }
    }

    private Builder() {
    }
}

