/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.archiver.JinArchiver;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.PeriodType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileArchive {
    private static final Pattern LINE_PATTERN;
    private static final DateFormat ISO_FORMAT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseISODate(String text) {
        Date date;
        try {
            DateFormat dateFormat = ISO_FORMAT;
            synchronized (dateFormat) {
                date = ISO_FORMAT.parse(text);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return date.getTime();
    }

    public static PeriodResource parseDownLogLine(CharSequence logLine) {
        URL fileUrl;
        PeriodType periodType;
        Matcher matcher = LINE_PATTERN.matcher(logLine);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        String fname = matcher.group(1);
        String landId = matcher.group(2);
        int villageId = Integer.parseInt(matcher.group(3));
        int day = Integer.parseInt(matcher.group(4));
        if (matcher.start(5) >= 0) {
            periodType = PeriodType.PROLOGUE;
        } else if (matcher.start(6) >= 0) {
            periodType = PeriodType.PROGRESS;
        } else if (matcher.start(7) >= 0) {
            periodType = PeriodType.EPILOGUE;
        } else {
            throw new IllegalArgumentException();
        }
        String uriText = matcher.group(8);
        String dateText = matcher.group(9);
        int hasError = Integer.parseInt(matcher.group(10));
        if (hasError != 0) {
            throw new IllegalArgumentException();
        }
        long dateMs = FileArchive.parseISODate(dateText);
        if (landId.equals("wolf0")) {
            landId = "wolf";
        }
        if (landId.equals("wolf1")) {
            landId = "wolf0";
        }
        LandDef landDef = JinArchiver.getLandDef(landId);
        File file = new File(fname);
        URI fileUri = file.toURI();
        try {
            fileUrl = fileUri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        PeriodResource result = new PeriodResource(landDef, villageId, periodType, day, uriText, dateMs, fileUrl);
        return result;
    }

    public static List<PeriodResource> parseDownList(LineNumberReader reader) throws IOException {
        String line;
        LinkedList<PeriodResource> result = new LinkedList<PeriodResource>();
        while ((line = reader.readLine()) != null) {
            PeriodResource info = FileArchive.parseDownLogLine(line);
            if (info == null) {
                throw new IllegalArgumentException();
            }
            result.add(info);
        }
        return result;
    }

    public static List<PeriodResource> parseDownloadLog(InputStream istream) throws IOException {
        InputStreamReader reader = new InputStreamReader(istream, "US-ASCII");
        LineNumberReader lineReader = new LineNumberReader(reader);
        List<PeriodResource> result = FileArchive.parseDownList(lineReader);
        lineReader.close();
        return result;
    }

    private FileArchive() {
        throw new Error();
    }

    static {
        String fnameRegex = "(jin_([^_]+)_(\\d+)_(\\d+)_(?:(prologue)|(progress)|(epilogue))\\.html)";
        LINE_PATTERN = Pattern.compile("^" + fnameRegex + "\\s+(\\S+)\\s+(\\S+)\\s+(\\d)" + "$");
        ISO_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.JAPAN);
    }
}

