/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.parser.DecodedContent;

public abstract class TopicData {
    private static final DecodedContent BREAK = new DecodedContent("\n");
    private final List<DecodedContent> lineList = new LinkedList<DecodedContent>();

    protected TopicData() {
    }

    public void addLine(DecodedContent content) {
        this.lineList.add(content);
    }

    public void addBreak() {
        this.lineList.add(BREAK);
    }

    public int getLineNum() {
        return this.lineList.size();
    }

    public DecodedContent get1stLine() {
        return this.lineList.get(0);
    }

    public void dumpLines(Writer writer) throws IOException {
        DecodedContent lastLine = null;
        DecodedContent lastContent = null;
        Iterator<DecodedContent> i$ = this.lineList.iterator();
        while (i$.hasNext()) {
            DecodedContent content;
            lastContent = content = i$.next();
            if (content == BREAK) {
                if (lastLine != null) {
                    writer.append("</li>\n");
                    lastLine = null;
                    continue;
                }
                writer.append("<li/>\n");
                continue;
            }
            if (lastLine == null) {
                writer.append("<li>");
            }
            XmlUtils.dumpDecodedContent(writer, content);
            lastLine = content;
        }
        if (lastLine != null) {
            writer.append("</li>\n");
        } else if (lastContent == BREAK) {
            writer.append("<li/>\n");
        }
    }

    public abstract void dumpXml(Writer var1) throws IOException;
}

